/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.profiles.OWL2DLProfile;
import org.semanticweb.owlapi.profiles.OWLOntologyProfileWalker;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.profiles.Profiles;
import org.semanticweb.owlapi.profiles.violations.LastPropertyInChainNotInImposedRange;
import org.semanticweb.owlapi.profiles.violations.UseOfAnonymousIndividual;
import org.semanticweb.owlapi.profiles.violations.UseOfDataOneOfWithMultipleLiterals;
import org.semanticweb.owlapi.profiles.violations.UseOfIllegalAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfIllegalClassExpression;
import org.semanticweb.owlapi.profiles.violations.UseOfIllegalDataRange;
import org.semanticweb.owlapi.profiles.violations.UseOfObjectOneOfWithMultipleIndividuals;
import org.semanticweb.owlapi.profiles.violations.UseOfObjectPropertyInverse;
import org.semanticweb.owlapi.util.OWLObjectPropertyManager;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWL2ELProfile
implements OWLProfile {
    protected static final Set<IRI> ALLOWED_DATATYPES = new HashSet<IRI>(Arrays.asList(OWL2Datatype.RDF_PLAIN_LITERAL.getIRI(), OWL2Datatype.RDF_XML_LITERAL.getIRI(), OWL2Datatype.RDFS_LITERAL.getIRI(), OWL2Datatype.OWL_RATIONAL.getIRI(), OWL2Datatype.OWL_REAL.getIRI(), OWL2Datatype.XSD_DECIMAL.getIRI(), OWL2Datatype.XSD_DECIMAL.getIRI(), OWL2Datatype.XSD_INTEGER.getIRI(), OWL2Datatype.XSD_NON_NEGATIVE_INTEGER.getIRI(), OWL2Datatype.XSD_STRING.getIRI(), OWL2Datatype.XSD_NORMALIZED_STRING.getIRI(), OWL2Datatype.XSD_TOKEN.getIRI(), OWL2Datatype.XSD_NAME.getIRI(), OWL2Datatype.XSD_NCNAME.getIRI(), OWL2Datatype.XSD_NMTOKEN.getIRI(), OWL2Datatype.XSD_HEX_BINARY.getIRI(), OWL2Datatype.XSD_BASE_64_BINARY.getIRI(), OWL2Datatype.XSD_ANY_URI.getIRI(), OWL2Datatype.XSD_DATE_TIME.getIRI(), OWL2Datatype.XSD_DATE_TIME_STAMP.getIRI()));

    @Override
    public String getName() {
        return "OWL 2 EL";
    }

    @Override
    @Nonnull
    public IRI getIRI() {
        return Profiles.OWL2_EL.getIRI();
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology) {
        OWL2DLProfile profile = new OWL2DLProfile();
        OWLProfileReport report = profile.checkOntology(ontology);
        HashSet<OWLProfileViolation> violations = new HashSet<OWLProfileViolation>();
        violations.addAll(report.getViolations());
        OWLOntologyProfileWalker ontologyWalker = new OWLOntologyProfileWalker(ontology.getImportsClosure());
        OWL2ELProfileObjectVisitor visitor = new OWL2ELProfileObjectVisitor(ontologyWalker, ontology.getOWLOntologyManager());
        ontologyWalker.walkStructure(visitor);
        violations.addAll(visitor.getProfileViolations());
        return new OWLProfileReport(this, violations);
    }

    protected class OWL2ELProfileObjectVisitor
    extends OWLOntologyWalkerVisitor {
        @Nonnull
        private final OWLOntologyManager man;
        private OWLObjectPropertyManager propertyManager;
        @Nonnull
        private final Set<OWLProfileViolation> profileViolations;

        public OWL2ELProfileObjectVisitor(@Nonnull OWLOntologyWalker walker, OWLOntologyManager man) {
            super(walker);
            this.profileViolations = new HashSet<OWLProfileViolation>();
            this.man = man;
        }

        public Set<OWLProfileViolation> getProfileViolations() {
            return new HashSet<OWLProfileViolation>(this.profileViolations);
        }

        private OWLObjectPropertyManager getPropertyManager() {
            if (this.propertyManager == null) {
                this.propertyManager = new OWLObjectPropertyManager(this.man, this.getCurrentOntology());
            }
            return this.propertyManager;
        }

        @Override
        public void visit(OWLDatatype node) {
            if (!ALLOWED_DATATYPES.contains(node.getIRI())) {
                this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            }
        }

        @Override
        public void visit(OWLAnonymousIndividual individual) {
            this.profileViolations.add(new UseOfAnonymousIndividual(this.getCurrentOntology(), this.getCurrentAxiom(), individual));
        }

        @Override
        public void visit(OWLObjectInverseOf property) {
            this.profileViolations.add(new UseOfObjectPropertyInverse(this.getCurrentOntology(), this.getCurrentAxiom(), property));
        }

        @Override
        public void visit(OWLDataAllValuesFrom ce) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
        }

        @Override
        public void visit(OWLDataExactCardinality ce) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
        }

        @Override
        public void visit(OWLDataMaxCardinality ce) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
        }

        @Override
        public void visit(OWLDataMinCardinality ce) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
        }

        @Override
        public void visit(OWLObjectAllValuesFrom ce) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
        }

        @Override
        public void visit(OWLObjectComplementOf ce) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
        }

        @Override
        public void visit(OWLObjectExactCardinality ce) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
        }

        @Override
        public void visit(OWLObjectMaxCardinality ce) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
        }

        @Override
        public void visit(OWLObjectMinCardinality ce) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
        }

        @Override
        public void visit(OWLObjectOneOf ce) {
            if (ce.getIndividuals().size() != 1) {
                this.profileViolations.add(new UseOfObjectOneOfWithMultipleIndividuals(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
            }
        }

        @Override
        public void visit(OWLObjectUnionOf ce) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
        }

        @Override
        public void visit(OWLDataComplementOf node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }

        @Override
        public void visit(OWLDataOneOf node) {
            if (node.getValues().size() != 1) {
                this.profileViolations.add(new UseOfDataOneOfWithMultipleLiterals(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            }
        }

        @Override
        public void visit(OWLDatatypeRestriction node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }

        @Override
        public void visit(OWLDataUnionOf node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }

        @Override
        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            axiom.getClassExpression().accept(this);
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(SWRLRule rule) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), rule));
        }

        @Override
        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            Set<OWLObjectPropertyRangeAxiom> rangeAxioms = this.getCurrentOntology().getAxioms(AxiomType.OBJECT_PROPERTY_RANGE, Imports.INCLUDED);
            if (rangeAxioms.isEmpty()) {
                return;
            }
            for (OWLObjectPropertyRangeAxiom rngAx : rangeAxioms) {
                if (!this.getPropertyManager().isSubPropertyOf(axiom.getSuperProperty(), (OWLObjectPropertyExpression)rngAx.getProperty())) continue;
                OWLClassExpression imposedRange = (OWLClassExpression)rngAx.getRange();
                List<OWLObjectPropertyExpression> chain = axiom.getPropertyChain();
                if (chain.isEmpty()) continue;
                OWLObjectPropertyExpression lastProperty = chain.get(chain.size() - 1);
                assert (lastProperty != null);
                boolean rngPresent = false;
                block1: for (OWLOntology ont : this.getCurrentOntology().getImportsClosure()) {
                    for (OWLObjectPropertyRangeAxiom lastPropRngAx : ont.getObjectPropertyRangeAxioms(lastProperty)) {
                        if (!((OWLClassExpression)lastPropRngAx.getRange()).equals(imposedRange)) continue;
                        rngPresent = true;
                        continue block1;
                    }
                }
                if (rngPresent) continue;
                this.profileViolations.add(new LastPropertyInChainNotInImposedRange(this.getCurrentOntology(), axiom, rngAx));
            }
        }

        @Override
        public void visit(OWLOntology ontology) {
            this.propertyManager = null;
        }
    }
}

