/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Locale;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.owl.owlapi.OWL2DatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternals;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplBoolean;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplDouble;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplFloat;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplInteger;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplNoCompression;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

public class InternalsNoCache
implements OWLDataFactoryInternals,
Serializable {
    private static final long serialVersionUID = 30402L;
    private static final OWLDatatype RDF_PLAIN_LITERAL = OWL2DatatypeImpl.getDatatype(OWL2Datatype.RDF_PLAIN_LITERAL);
    private static final OWLDatatype XSD_BOOLEAN = OWL2DatatypeImpl.getDatatype(OWL2Datatype.XSD_BOOLEAN);
    private static final OWLDatatype XSD_DOUBLE = OWL2DatatypeImpl.getDatatype(OWL2Datatype.XSD_DOUBLE);
    private static final OWLDatatype XSD_FLOAT = OWL2DatatypeImpl.getDatatype(OWL2Datatype.XSD_FLOAT);
    private static final OWLDatatype XSD_INTEGER = OWL2DatatypeImpl.getDatatype(OWL2Datatype.XSD_INTEGER);
    private static final OWLDatatype RDFS_LITERAL = OWL2DatatypeImpl.getDatatype(OWL2Datatype.RDFS_LITERAL);
    private final OWLDataFactory factory;
    private final OWLLiteral trueLiteral;
    private final OWLLiteral falseLiteral;
    private OWLLiteral negativeFloatZero;
    private final boolean useCompression;

    public InternalsNoCache(OWLDataFactory f, boolean useCompression) {
        this.factory = f;
        this.trueLiteral = new OWLLiteralImplBoolean(true);
        this.falseLiteral = new OWLLiteralImplBoolean(false);
        this.useCompression = useCompression;
    }

    @Override
    public void purge() {
    }

    @Override
    public OWLClass getOWLClass(IRI iri) {
        return new OWLClassImpl(iri);
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return new OWLObjectPropertyImpl(iri);
    }

    @Override
    public OWLDataProperty getOWLDataProperty(IRI iri) {
        return new OWLDataPropertyImpl(iri);
    }

    @Override
    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        return new OWLNamedIndividualImpl(iri);
    }

    @Override
    public OWLDatatype getOWLDatatype(IRI iri) {
        return new OWLDatatypeImpl(iri);
    }

    @Override
    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        return new OWLAnnotationPropertyImpl(iri);
    }

    @Override
    public OWLLiteral getOWLLiteral(float value) {
        return new OWLLiteralImplFloat(value, this.getFloatOWLDatatype());
    }

    @Override
    public OWLLiteral getOWLLiteral(String value) {
        if (this.useCompression) {
            return new OWLLiteralImpl(value, "", this.getOWLDatatype(XSDVocabulary.STRING.getIRI()));
        }
        return new OWLLiteralImplNoCompression(value, "", this.getOWLDatatype(XSDVocabulary.STRING.getIRI()));
    }

    @Override
    public OWLLiteral getOWLLiteral(String literal, String lang) {
        String normalisedLang = lang == null ? "" : lang.trim().toLowerCase(Locale.ENGLISH);
        if (this.useCompression) {
            return new OWLLiteralImpl(literal, normalisedLang, null);
        }
        return new OWLLiteralImplNoCompression(literal, normalisedLang, null);
    }

    @Override
    public OWLLiteral getOWLLiteral(int value) {
        return new OWLLiteralImplInteger(value, this.getIntegerOWLDatatype());
    }

    @Override
    public OWLLiteral getOWLLiteral(boolean value) {
        return value ? this.trueLiteral : this.falseLiteral;
    }

    @Override
    public OWLLiteral getOWLLiteral(double value) {
        return new OWLLiteralImplDouble(value, this.getDoubleOWLDatatype());
    }

    @Override
    public OWLLiteral getOWLLiteral(String lexicalValue, OWLDatatype datatype) {
        OWLLiteral literal;
        if (datatype.isRDFPlainLiteral()) {
            int sep = lexicalValue.lastIndexOf(64);
            if (sep != -1) {
                String lex = lexicalValue.substring(0, sep);
                String lang = lexicalValue.substring(sep + 1);
                literal = this.getBasicLiteral(lex, lang, this.getRDFPlainLiteral());
            } else {
                literal = this.getBasicLiteral(lexicalValue, datatype);
            }
        } else {
            try {
                if (datatype.isBoolean()) {
                    literal = this.isBooleanTrueValue(lexicalValue = lexicalValue.trim()) ? this.getOWLLiteral(true) : (this.isBooleanFalseValue(lexicalValue) ? this.getOWLLiteral(false) : this.factory.getOWLLiteral(Boolean.parseBoolean(lexicalValue)));
                } else if (datatype.isFloat()) {
                    if (lexicalValue.trim().equals("-0.0")) {
                        if (this.negativeFloatZero == null) {
                            this.negativeFloatZero = this.getBasicLiteral("-0.0", XSD_FLOAT);
                        }
                        literal = this.negativeFloatZero;
                    } else {
                        try {
                            float f = Float.parseFloat(lexicalValue);
                            literal = this.getOWLLiteral(f);
                        }
                        catch (NumberFormatException e) {
                            literal = this.getBasicLiteral(lexicalValue, datatype);
                        }
                    }
                } else if (datatype.isDouble()) {
                    literal = this.getOWLLiteral(Double.parseDouble(lexicalValue));
                } else if (datatype.isInteger()) {
                    if (lexicalValue.trim().charAt(0) == '0') {
                        literal = this.getBasicLiteral(lexicalValue, this.getIntegerOWLDatatype());
                    } else {
                        try {
                            literal = this.getOWLLiteral(Integer.parseInt(lexicalValue));
                        }
                        catch (NumberFormatException ex) {
                            BigDecimal bigint = new BigDecimal(lexicalValue);
                            literal = this.getOWLLiteral(bigint.intValue());
                        }
                    }
                } else {
                    literal = this.getBasicLiteral(lexicalValue, datatype);
                }
            }
            catch (NumberFormatException e) {
                literal = this.getBasicLiteral(lexicalValue, datatype);
            }
        }
        return literal;
    }

    protected OWLLiteral getBasicLiteral(String lexicalValue, OWLDatatype datatype) {
        return this.getBasicLiteral(lexicalValue, "", datatype);
    }

    protected OWLLiteral getBasicLiteral(String lexicalValue, String lang, OWLDatatype datatype) {
        OWLObjectImpl literal = null;
        literal = this.useCompression ? new OWLLiteralImpl(lexicalValue, lang, datatype) : new OWLLiteralImplNoCompression(lexicalValue, lang, datatype);
        return literal;
    }

    private boolean isBooleanFalseValue(String lexicalValue) {
        return lexicalValue.equals("0") || lexicalValue.equals("false");
    }

    private boolean isBooleanTrueValue(String lexicalValue) {
        return lexicalValue.equals("1") || lexicalValue.equals("true");
    }

    @Override
    public OWLDatatype getTopDatatype() {
        return RDFS_LITERAL;
    }

    @Override
    public OWLDatatype getIntegerOWLDatatype() {
        return XSD_INTEGER;
    }

    @Override
    public OWLDatatype getFloatOWLDatatype() {
        return XSD_FLOAT;
    }

    @Override
    public OWLDatatype getDoubleOWLDatatype() {
        return XSD_DOUBLE;
    }

    @Override
    public OWLDatatype getBooleanOWLDatatype() {
        return XSD_BOOLEAN;
    }

    @Override
    public OWLDatatype getRDFPlainLiteral() {
        return RDF_PLAIN_LITERAL;
    }
}

