/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.MultiMap;
import uk.ac.manchester.cs.owl.owlapi.InitVisitorFactory;
import uk.ac.manchester.cs.owl.owlapi.Internals;

public class MapPointer<K, V extends OWLAxiom>
implements Internals.Pointer<K, V>,
Serializable {
    private static final long serialVersionUID = 30402L;
    private final MultiMap<K, V> map;
    private final AxiomType<?> type;
    private final OWLAxiomVisitorEx<?> visitor;
    private boolean initialized;
    protected final Internals i;

    public MapPointer(AxiomType<?> t, OWLAxiomVisitorEx<?> v, boolean initialized, Internals i) {
        this.type = t;
        this.visitor = v;
        this.map = new MultiMap();
        this.initialized = initialized;
        this.i = i;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.visitor == null) {
            return;
        }
        if (this.visitor instanceof InitVisitorFactory.InitVisitor) {
            for (OWLAxiom ax : this.i.getValues(this.i.getAxiomsByType(), this.type)) {
                Object key = ax.accept((OWLAxiomVisitorEx)((InitVisitorFactory.InitVisitor)this.visitor));
                if (key == null) continue;
                this.map.put(key, (Object)ax);
            }
        } else {
            for (OWLAxiom ax : this.i.getValues(this.i.getAxiomsByType(), this.type)) {
                Collection keys = (Collection)ax.accept((OWLAxiomVisitorEx)((InitVisitorFactory.InitCollectionVisitor)this.visitor));
                for (Object key : keys) {
                    this.map.put(key, (Object)ax);
                }
            }
        }
    }

    public String toString() {
        return this.initialized + this.map.toString();
    }

    public Set<K> keySet() {
        return CollectionFactory.getCopyOnRequestSetFromMutableCollection((Collection)this.map.keySet());
    }

    public Set<V> getValues(K key) {
        return CollectionFactory.getCopyOnRequestSetFromMutableCollection((Collection)this.map.get(key));
    }

    public boolean hasValues(K key) {
        return this.map.containsKey(key);
    }

    public boolean put(K key, V value) {
        return this.map.put(key, value);
    }

    public boolean remove(K key, V value) {
        return this.map.remove(key, value);
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean contains(K key, V value) {
        return this.map.contains(key, value);
    }

    public Set<V> getAllValues() {
        return this.map.getAllValues();
    }

    public int size() {
        return this.map.size();
    }
}

