/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.util.CollectionFactory;
import uk.ac.manchester.cs.owl.owlapi.OWLLogicalAxiomImpl;

public class OWLHasKeyAxiomImpl
extends OWLLogicalAxiomImpl
implements OWLHasKeyAxiom {
    private static final long serialVersionUID = 30402L;
    private final OWLClassExpression expression;
    private final Set<OWLPropertyExpression<?, ?>> propertyExpressions;

    public OWLHasKeyAxiomImpl(OWLClassExpression expression, Set<? extends OWLPropertyExpression<?, ?>> propertyExpressions, Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.expression = expression;
        this.propertyExpressions = new TreeSet(propertyExpressions);
    }

    public OWLHasKeyAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return OWLHasKeyAxiomImpl.getOWLDataFactory().getOWLHasKeyAxiom(this.getClassExpression(), this.getPropertyExpressions());
    }

    public OWLHasKeyAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return OWLHasKeyAxiomImpl.getOWLDataFactory().getOWLHasKeyAxiom(this.getClassExpression(), this.getPropertyExpressions(), this.mergeAnnos(annotations));
    }

    public AxiomType<?> getAxiomType() {
        return AxiomType.HAS_KEY;
    }

    @Override
    public boolean isLogicalAxiom() {
        return true;
    }

    public OWLClassExpression getClassExpression() {
        return this.expression;
    }

    public Set<OWLPropertyExpression<?, ?>> getPropertyExpressions() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.propertyExpressions);
    }

    public Set<OWLDataPropertyExpression> getDataPropertyExpressions() {
        TreeSet<OWLDataPropertyExpression> props = new TreeSet<OWLDataPropertyExpression>();
        for (OWLPropertyExpression<?, ?> prop : this.propertyExpressions) {
            if (!prop.isDataPropertyExpression()) continue;
            props.add((OWLDataPropertyExpression)prop);
        }
        return props;
    }

    public Set<OWLObjectPropertyExpression> getObjectPropertyExpressions() {
        TreeSet<OWLObjectPropertyExpression> props = new TreeSet<OWLObjectPropertyExpression>();
        for (OWLPropertyExpression<?, ?> prop : this.propertyExpressions) {
            if (!prop.isObjectPropertyExpression()) continue;
            props.add((OWLObjectPropertyExpression)prop);
        }
        return props;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLHasKeyAxiom other = (OWLHasKeyAxiom)object;
        int diff = this.expression.compareTo((Object)other.getClassExpression());
        if (diff != 0) {
            return diff;
        }
        return OWLHasKeyAxiomImpl.compareSets(this.propertyExpressions, other.getPropertyExpressions());
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLHasKeyAxiom)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLHasKeyAxiom)this);
    }

    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit((OWLHasKeyAxiom)this);
    }

    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLHasKeyAxiom)this);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLHasKeyAxiom)) {
                return false;
            }
            OWLHasKeyAxiom other = (OWLHasKeyAxiom)obj;
            return this.expression.equals(other.getClassExpression()) && this.propertyExpressions.equals(other.getPropertyExpressions());
        }
        return false;
    }
}

