/*
 * Created on Sep 23, 2005 
 */
package net.sourceforge.wife.swift.parser;



/**
 * Base class for swift messages.
 *  
 * @author mgriffa
 * @version $Id: SwiftMessage.java,v 1.1 2006/02/28 19:26:34 mikkey Exp $
 */
public class SwiftMessage {
    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(SwiftMessage.class);
    protected final SwiftBlock1 block1 = new SwiftBlock1();
    protected final SwiftBlock2 block2 = new SwiftBlock2();
    protected final SwiftBlock3 block3 = new SwiftBlock3();
    protected final SwiftBlock4 block4 = new SwiftBlock4();
    protected final SwiftBlock5 block5 = new SwiftBlock5();
    
    public SwiftBlock1 getBlock1() {
        return block1;
    }
    public void setBlock1(SwiftBlock1 block1) {
        this.block1.setData(block1);
    }
    public SwiftBlock2 getBlock2() {
        return block2;
    }
    public void setBlock2(SwiftBlock2 block2) {
        this.block2.setData(block2);
    }
    public SwiftBlock3 getBlock3() {
        return block3;
    }
    public void setBlock3(SwiftBlock3 block3) {
        this.block3.setData(block3);
    }
    public SwiftBlock4 getBlock4() {
        return block4;
    }
    public void setBlock4(SwiftBlock4 block4) {
        this.block4.setData(block4);
    }
    public SwiftBlock5 getBlock5() {
        return block5;
    }
    public void setBlock5(SwiftBlock5 block5) {
        this.block5.setData(block5);
    }
    
    private String messageCode() {
        if (block2!=null) {
            String v = block2.getOnlyValue();
            if (v!=null) {
                if (v.length()>=4) {
                    return v.substring(1, 4);
                }
            }
        }
        return null;
    }
    
    public SwiftBlock getBlock(int b) {
        switch (b) {
        case 1:
            return getBlock1();
        case 2:
        	return getBlock2();
        case 3:
        	return getBlock3();
        case 4:
        	return getBlock4();
        case 5:
        	return getBlock5();
        default:
            throw new IllegalArgumentException("Bloque desconocido: "+b);
        }
    }
    public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[SwiftMessage:");
            buffer.append(" log: ");
            buffer.append(log);
            buffer.append(" block1: ");
            buffer.append(block1);
            buffer.append(" block2: ");
            buffer.append(block2);
            buffer.append(" block3: ");
            buffer.append(block3);
            buffer.append(" block4: ");
            buffer.append(block4);
            buffer.append(" block5: ");
            buffer.append(block5);
            buffer.append("]");
            return buffer.toString();
        }

}
