/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.stickycode.reflector.predicate.FieldPredicate;
import net.stickycode.reflector.predicate.MethodPredicate;
import net.stickycode.reflector.predicate.TypePredicate;

public class MetaAnnotatedElementPredicate
implements MethodPredicate,
FieldPredicate,
TypePredicate {
    private Class<? extends Annotation>[] annotations;

    public MetaAnnotatedElementPredicate(Class<? extends Annotation> ... annotations) {
        this.annotations = annotations;
    }

    public boolean apply(Method method) {
        return this.isMetaAnnotated(method);
    }

    public boolean apply(Class<?> type) {
        return this.isMetaAnnotated(type);
    }

    public boolean apply(Field field) {
        return this.isMetaAnnotated(field);
    }

    public boolean apply(AnnotatedElement annotatedElement) {
        return this.isMetaAnnotated(annotatedElement);
    }

    private boolean isMetaAnnotated(AnnotatedElement element) {
        for (Class<? extends Annotation> a : this.annotations) {
            if (element.isAnnotationPresent(a)) {
                return true;
            }
            for (Annotation annotation : element.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(a)) continue;
                return true;
            }
        }
        return false;
    }
}

