/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.pages.PageObject;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.DependencyInjector;

public class PageObjectDependencyInjector
implements DependencyInjector {
    private final Pages pages;

    public PageObjectDependencyInjector(Pages pages) {
        this.pages = pages;
    }

    @Override
    public void injectDependenciesInto(Object target) {
        List<Field> pageObjectFields = this.pageObjectFieldsIn(target);
        for (Field pageObjectField : pageObjectFields) {
            this.instantiatePageObjectIfNotAssigned(pageObjectField, target);
        }
    }

    private void instantiatePageObjectIfNotAssigned(Field pageObjectField, Object target) {
        try {
            pageObjectField.setAccessible(true);
            if (pageObjectField.get(target) == null) {
                Class<?> pageObjectClass = pageObjectField.getType();
                Object newPageObject = this.pages.getPage(pageObjectClass);
                this.injectDependenciesInto(newPageObject);
                pageObjectField.set(target, newPageObject);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not instanciate page objects in " + target);
        }
    }

    private List<Field> pageObjectFieldsIn(Object target) {
        Set<Field> allFields = Fields.of(target.getClass()).allFields();
        ArrayList pageObjectFields = Lists.newArrayList();
        for (Field field : allFields) {
            if (!PageObject.class.isAssignableFrom(field.getType())) continue;
            pageObjectFields.add(field);
        }
        return pageObjectFields;
    }
}

