/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webelements;

import com.google.common.base.Optional;
import java.util.List;
import org.openqa.selenium.WebElement;

public class RadioButtonGroup {
    private final List<WebElement> radioButtons;

    public RadioButtonGroup(List<WebElement> radioButtons) {
        this.radioButtons = radioButtons;
    }

    public Optional<String> getSelectedValue() {
        for (WebElement radioButton : this.radioButtons) {
            if (!radioButton.isSelected()) continue;
            return Optional.of((Object)radioButton.getAttribute("value"));
        }
        return Optional.absent();
    }

    public void selectByValue(String value) {
        for (WebElement radioButton : this.radioButtons) {
            if (!value.equals(radioButton.getAttribute("value"))) continue;
            radioButton.click();
            break;
        }
    }

    public void selectByVisibleText(String label) {
        for (WebElement radioButton : this.radioButtons) {
            if (!label.equalsIgnoreCase(radioButton.getText())) continue;
            radioButton.click();
            break;
        }
    }
}

