package net.thucydides.core.reports.templates;

import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;

public class FreemarkerReportTemplate implements ReportTemplate {

    private final Template template;

    private static final Logger LOGGER = LoggerFactory.getLogger(FreemarkerReportTemplate.class);

    public FreemarkerReportTemplate(final Configuration configuration, final String templateFile) throws IOException, TemplateMergeException {
        try {
            template = configuration.getTemplate(templateFile);
        } catch (ParseException parseException) {
            throw new TemplateMergeException("Parsing error in template", parseException);
        }
    }

    public void merge(Map<String, Object> context, StringWriter writer) throws TemplateMergeException {
        try {
            template.process(context, writer);
        } catch (TemplateException templateException) {
            LOGGER.error("Syntax error in report template: {}\n{}", templateException.getMessage(), templateException.getFTLInstructionStack());
            throw new TemplateMergeException("Failed to process FreeMarker template", templateException);
        } catch (IOException e) {
            throw new TemplateMergeException("Could not read FreeMarker template", e);
        }
    }
}
