/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import net.thucydides.core.IgnoredStepException;
import net.thucydides.core.PendingStepException;
import net.thucydides.core.SessionMap;
import net.thucydides.core.annotations.TestCaseAnnotations;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.sessions.TestSessionVariables;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.DependencyInjector;
import net.thucydides.core.steps.PageObjectDependencyInjector;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.di.DependencyInjectorService;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverManager;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxProfile;

public class Thucydides {
    private static final ThreadLocal<WebDriverFactory> factoryThreadLocal = new ThreadLocal();
    private static final ThreadLocal<WebdriverManager> webdriverManagerThreadLocal = new ThreadLocal();
    private static final ThreadLocal<Pages> pagesThreadLocal = new ThreadLocal();
    private static final ThreadLocal<StepFactory> stepFactoryThreadLocal = new ThreadLocal();
    private static final ThreadLocal<StepListener> stepListenerThreadLocal = new ThreadLocal();
    private static final ThreadLocal<TestSessionVariables> testSessionThreadLocal = new ThreadLocal();
    private static final ThreadLocal<FirefoxProfile> firefoxProfileThreadLocal = new ThreadLocal();

    public static void initialize(Object testCase) {
        Thucydides.setupWebDriverFactory();
        Thucydides.setupWebdriverManager();
        Thucydides.initPagesObjectUsing(Thucydides.getDriver());
        Thucydides.initStepListener();
        Thucydides.initStepFactoryUsing(Thucydides.getPages());
        Thucydides.injectDriverInto(testCase);
        Thucydides.injectAnnotatedPagesObjectInto(testCase);
        Thucydides.injectScenarioStepsInto(testCase);
        ThucydidesWebDriverSupport.initializeFieldsIn(testCase);
        Thucydides.injectDependenciesInto(testCase);
    }

    private static void injectDependenciesInto(Object testCase) {
        List<DependencyInjector> dependencyInjectors = Thucydides.getDependencyInjectorService().findDependencyInjectors();
        dependencyInjectors.addAll(Thucydides.getDefaultDependencyInjectors());
        for (DependencyInjector dependencyInjector : dependencyInjectors) {
            dependencyInjector.injectDependenciesInto(testCase);
        }
    }

    private static DependencyInjectorService getDependencyInjectorService() {
        return (DependencyInjectorService)Injectors.getInjector().getInstance(DependencyInjectorService.class);
    }

    private static List<DependencyInjector> getDefaultDependencyInjectors() {
        return ImmutableList.of((Object)new PageObjectDependencyInjector(Thucydides.getPages()));
    }

    public static void initializeWithNoStepListener(Object testCase) {
        Thucydides.setupWebDriverFactory();
        Thucydides.setupWebdriverManager();
        Thucydides.initPagesObjectUsing(Thucydides.getDriver());
        Thucydides.initStepFactoryUsing(Thucydides.getPages());
        Thucydides.injectDriverInto(testCase);
        Thucydides.injectAnnotatedPagesObjectInto(testCase);
        Thucydides.injectScenarioStepsInto(testCase);
        Thucydides.injectDependenciesInto(testCase);
    }

    private static void initStepListener() {
        Configuration configuration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        File outputDirectory = configuration.getOutputDirectory();
        BaseStepListener listener = new BaseStepListener(outputDirectory, Thucydides.getPages());
        stepListenerThreadLocal.set(listener);
        StepEventBus.getEventBus().registerListener(Thucydides.getStepListener());
    }

    private static void setupWebDriverFactory() {
        factoryThreadLocal.set((WebDriverFactory)Injectors.getInjector().getInstance(WebDriverFactory.class));
    }

    private static void initPagesObjectUsing(WebDriver driver) {
        pagesThreadLocal.set(new Pages(driver));
    }

    private static void initStepFactoryUsing(Pages pagesObject) {
        stepFactoryThreadLocal.set(new StepFactory(pagesObject));
    }

    protected static void injectDriverInto(Object testCase) {
        TestCaseAnnotations.forTestCase(testCase).injectDriver(Thucydides.getDriver());
    }

    public static void injectScenarioStepsInto(Object testCase) {
        StepAnnotations.injectScenarioStepsInto(testCase, Thucydides.getStepFactory());
    }

    protected static void injectAnnotatedPagesObjectInto(Object testCase) {
        StepAnnotations.injectOptionalAnnotatedPagesObjectInto(testCase, Thucydides.getPages());
    }

    public static void done() {
        if (Thucydides.getWebdriverManager() != null) {
            Thucydides.getWebdriverManager().closeAllCurrentDrivers();
        }
    }

    public static String getCurrentSessionID() {
        if (Thucydides.getWebdriverManager() != null && Thucydides.getWebdriverManager().getSessionId() != null) {
            return Thucydides.getWebdriverManager().getSessionId().toString();
        }
        return null;
    }

    protected static WebDriver getDriver() {
        return Thucydides.getWebdriverManager().getWebdriver();
    }

    protected static Pages getPages() {
        return pagesThreadLocal.get();
    }

    protected static void stopUsingMockDriver() {
        Thucydides.setupWebdriverManager();
    }

    private static WebdriverManager getWebdriverManager() {
        return webdriverManagerThreadLocal.get();
    }

    public static StepFactory getStepFactory() {
        return stepFactoryThreadLocal.get();
    }

    private static void setupWebdriverManager() {
        Thucydides.setupWebdriverManager((WebdriverManager)Injectors.getInjector().getInstance(WebdriverManager.class));
    }

    private static void setupWebdriverManager(WebdriverManager webdriverManager) {
        webdriverManagerThreadLocal.set(webdriverManager);
    }

    public static StepListener getStepListener() {
        return stepListenerThreadLocal.get();
    }

    public static void initializeTestSession() {
        Thucydides.getCurrentSession().clear();
    }

    public static SessionMap<String, Object> getCurrentSession() {
        if (testSessionThreadLocal.get() == null) {
            testSessionThreadLocal.set(new TestSessionVariables());
        }
        return testSessionThreadLocal.get();
    }

    public static void pendingStep(String reason) {
        throw new PendingStepException(reason);
    }

    public static void ignoredStep(String reason) {
        throw new IgnoredStepException(reason);
    }

    public static void takeScreenshot() {
        StepEventBus.getEventBus().takeScreenshot();
    }

    public static String getDefaultProjectKey() {
        String workingDirPath = System.getProperty("user.dir");
        return new File(workingDirPath).getName();
    }

    public static void useFirefoxProfile(FirefoxProfile profile) {
        firefoxProfileThreadLocal.set(profile);
    }

    public static FirefoxProfile getFirefoxProfile() {
        return firefoxProfileThreadLocal.get();
    }
}

