/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.hive;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.Text;

@Description(name="ParseUserAgent", value="_FUNC_(str) - Parses the UserAgent into all possible pieces.", extended="Example:\n> SELECT ParseUserAgent(useragent).DeviceClass, \n         ParseUserAgent(useragent).OperatingsystemNameVersion, \n         ParseUserAgent(useragent).AgentNameVersionMajor \n  FROM   clickLogs;\n+---------------+-----------------------------+------------------------+\n|  deviceclass  | operatingsystemnameversion  | agentnameversionmajor  |\n+---------------+-----------------------------+------------------------+\n| Phone         | Android 6.0                 | Chrome 46              |\n| Tablet        | Android 5.1                 | Chrome 40              |\n| Desktop       | Linux ??                    | Chrome 59              |\n| Game Console  | Windows 10.0                | Edge 13                |\n+---------------+-----------------------------+------------------------+\n")
public class ParseUserAgent
extends GenericUDF {
    private List<StringObjectInspector> argsOI = null;
    private static ThreadLocal<UserAgentAnalyzer> threadLocalUserAgentAnalyzer = ThreadLocal.withInitial(() -> (UserAgentAnalyzer)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)UserAgentAnalyzer.newBuilder().hideMatcherLoadStats()).withCache(10000)).useJava8CompatibleCaching()).immediateInitialization()).build());
    private List<String> fieldNames = null;
    private List<String> allHeaders = null;

    public void close() {
        threadLocalUserAgentAnalyzer.remove();
    }

    public ObjectInspector initialize(ObjectInspector[] args) throws UDFArgumentException {
        if (args.length == 0) {
            throw new UDFArgumentException("The argument list must be non empty");
        }
        this.argsOI = new ArrayList<StringObjectInspector>();
        for (ObjectInspector arg : args) {
            if (!(arg instanceof StringObjectInspector)) {
                throw new UDFArgumentException("The argument must be a string");
            }
            this.argsOI.add((StringObjectInspector)arg);
        }
        UserAgentAnalyzer userAgentAnalyzer = threadLocalUserAgentAnalyzer.get();
        this.fieldNames = userAgentAnalyzer.getAllPossibleFieldNamesSorted();
        this.allHeaders = new ArrayList<String>();
        this.allHeaders.add("User-Agent");
        this.allHeaders.addAll(userAgentAnalyzer.supportedClientHintHeaders());
        ArrayList fieldObjectInspectors = new ArrayList(this.fieldNames.size());
        this.fieldNames.forEach(f -> fieldObjectInspectors.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector));
        return ObjectInspectorFactory.getStandardStructObjectInspector(this.fieldNames, fieldObjectInspectors);
    }

    public Object evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        TreeMap<String, String> requestHeaders = new TreeMap<String, String>();
        int i = 0;
        while (i < this.argsOI.size()) {
            String parameter = this.argsOI.get(i).getPrimitiveJavaObject(args[i].get());
            if (parameter != null) {
                if (this.allHeaders.stream().anyMatch(parameter::equalsIgnoreCase)) {
                    if (i + 1 >= this.argsOI.size()) {
                        throw new IllegalArgumentException("Invalid last element in argument list (was a header name which requires a value to follow)");
                    }
                    String value = this.argsOI.get(i + 1).getPrimitiveJavaObject(args[i + 1].get());
                    ++i;
                    requestHeaders.put(parameter, value);
                    ++i;
                    continue;
                }
            }
            if (i == 0) {
                requestHeaders.put("User-Agent", parameter);
                ++i;
                continue;
            }
            throw new IllegalArgumentException("Bad argument list for ParseUserAgent.");
        }
        UserAgent.ImmutableUserAgent userAgent = threadLocalUserAgentAnalyzer.get().parse(requestHeaders);
        ArrayList<Text> result = new ArrayList<Text>(this.fieldNames.size());
        for (String fieldName : this.fieldNames) {
            String value = userAgent.getValue(fieldName);
            if (value == null) {
                result.add(null);
                continue;
            }
            result.add(new Text(value));
        }
        return result.toArray();
    }

    public String getDisplayString(String[] args) {
        return "Parses the UserAgent into all possible pieces.";
    }
}

