/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.lib.geotools;

public class UTMZone {
    private final Hemisphere hemisphere;
    private final int number;
    private final String EPSG;

    public UTMZone(int number, Hemisphere hemisphere) {
        this.hemisphere = hemisphere;
        this.number = number;
        if (number < 0 || number > 60) {
            throw new IllegalArgumentException("Argument number should be between 0 and 60");
        }
        String no = String.valueOf(number);
        no = no.length() == 1 ? "0" + no : no;
        this.EPSG = "32" + (Hemisphere.NORTHERN.equals((Object)hemisphere) ? "6" : "7") + no;
    }

    public String getEPSG() {
        return this.EPSG;
    }

    public Hemisphere getHemisphere() {
        return this.hemisphere;
    }

    public int getNumber() {
        return this.number;
    }

    public static UTMZone fromGPSCoordinates(double latitude, double longitude) {
        return new UTMZone(UTMZone.longitudeToZoneNumber(longitude), UTMZone.latitudeToHemisphere(latitude));
    }

    public static int longitudeToZoneNumber(double longitude) {
        return new Double(Math.floor((longitude + 180.0) / 6.0)).intValue() + 1;
    }

    public static Hemisphere latitudeToHemisphere(double latitude) {
        return latitude >= 0.0 ? Hemisphere.NORTHERN : Hemisphere.SOUTHERN;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UTMZone other = (UTMZone)obj;
        if (this.hemisphere != other.hemisphere) {
            return false;
        }
        return this.number == other.number;
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (this.hemisphere != null ? this.hemisphere.hashCode() : 0);
        hash = 61 * hash + this.number;
        return hash;
    }

    public static enum Hemisphere {
        NORTHERN,
        SOUTHERN;

    }
}

