/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.captcha;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.securechannel.ChannelEntryPoint;
import org.acegisecurity.util.PortMapper;
import org.acegisecurity.util.PortMapperImpl;
import org.acegisecurity.util.PortResolver;
import org.acegisecurity.util.PortResolverImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CaptchaEntryPoint
implements ChannelEntryPoint,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$captcha$CaptchaEntryPoint == null ? (class$org$acegisecurity$captcha$CaptchaEntryPoint = CaptchaEntryPoint.class$("org.acegisecurity.captcha.CaptchaEntryPoint")) : class$org$acegisecurity$captcha$CaptchaEntryPoint));
    private PortMapper portMapper = new PortMapperImpl();
    private PortResolver portResolver = new PortResolverImpl();
    private String captchaFormUrl;
    private String originalRequestMethodParameterName = "original_request_method";
    private String originalRequestParametersNameValueSeparator = "__";
    private String originalRequestParametersParameterName = "original_request_parameters";
    private String originalRequestParametersSeparator = ";;";
    private String originalRequestUrlParameterName = "original_requestUrl";
    private String urlEncodingCharset = "UTF-8";
    private boolean forceHttps = false;
    private boolean includeOriginalParameters = false;
    private boolean includeOriginalRequest = true;
    private boolean isOutsideWebApp = false;
    static /* synthetic */ Class class$org$acegisecurity$captcha$CaptchaEntryPoint;

    public void setCaptchaFormUrl(String captchaFormUrl) {
        this.captchaFormUrl = captchaFormUrl;
    }

    public String getCaptchaFormUrl() {
        return this.captchaFormUrl;
    }

    public void setForceHttps(boolean forceHttps) {
        this.forceHttps = forceHttps;
    }

    public boolean getForceHttps() {
        return this.forceHttps;
    }

    public void setIncludeOriginalParameters(boolean includeOriginalParameters) {
        this.includeOriginalParameters = includeOriginalParameters;
    }

    public boolean isIncludeOriginalParameters() {
        return this.includeOriginalParameters;
    }

    public void setIncludeOriginalRequest(boolean includeOriginalRequest) {
        this.includeOriginalRequest = includeOriginalRequest;
    }

    public boolean isIncludeOriginalRequest() {
        return this.includeOriginalRequest;
    }

    public void setOriginalRequestMethodParameterName(String originalRequestMethodParameterName) {
        this.originalRequestMethodParameterName = originalRequestMethodParameterName;
    }

    public String getOriginalRequestMethodParameterName() {
        return this.originalRequestMethodParameterName;
    }

    public void setOriginalRequestParametersNameValueSeparator(String originalRequestParametersNameValueSeparator) {
        this.originalRequestParametersNameValueSeparator = originalRequestParametersNameValueSeparator;
    }

    public String getOriginalRequestParametersNameValueSeparator() {
        return this.originalRequestParametersNameValueSeparator;
    }

    public void setOriginalRequestParametersParameterName(String originalRequestParametersParameterName) {
        this.originalRequestParametersParameterName = originalRequestParametersParameterName;
    }

    public String getOriginalRequestParametersParameterName() {
        return this.originalRequestParametersParameterName;
    }

    public void setOriginalRequestParametersSeparator(String originalRequestParametersSeparator) {
        this.originalRequestParametersSeparator = originalRequestParametersSeparator;
    }

    public String getOriginalRequestParametersSeparator() {
        return this.originalRequestParametersSeparator;
    }

    public void setOriginalRequestUrlParameterName(String originalRequestUrlParameterName) {
        this.originalRequestUrlParameterName = originalRequestUrlParameterName;
    }

    public String getOriginalRequestUrlParameterName() {
        return this.originalRequestUrlParameterName;
    }

    public void setOutsideWebApp(boolean isOutsideWebApp) {
        this.isOutsideWebApp = isOutsideWebApp;
    }

    public boolean isOutsideWebApp() {
        return this.isOutsideWebApp;
    }

    public void setPortMapper(PortMapper portMapper) {
        this.portMapper = portMapper;
    }

    public PortMapper getPortMapper() {
        return this.portMapper;
    }

    public void setPortResolver(PortResolver portResolver) {
        this.portResolver = portResolver;
    }

    public PortResolver getPortResolver() {
        return this.portResolver;
    }

    public void setUrlEncodingCharset(String urlEncodingCharset) {
        this.urlEncodingCharset = urlEncodingCharset;
    }

    public String getUrlEncodingCharset() {
        return this.urlEncodingCharset;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.captchaFormUrl, (String)"captchaFormUrl must be specified");
        Assert.hasLength((String)this.originalRequestMethodParameterName, (String)"originalRequestMethodParameterName must be specified");
        Assert.hasLength((String)this.originalRequestParametersNameValueSeparator, (String)"originalRequestParametersNameValueSeparator must be specified");
        Assert.hasLength((String)this.originalRequestParametersParameterName, (String)"originalRequestParametersParameterName must be specified");
        Assert.hasLength((String)this.originalRequestParametersSeparator, (String)"originalRequestParametersSeparator must be specified");
        Assert.hasLength((String)this.originalRequestUrlParameterName, (String)"originalRequestUrlParameterName must be specified");
        Assert.hasLength((String)this.urlEncodingCharset, (String)"urlEncodingCharset must be specified");
        Assert.notNull((Object)this.portMapper, (String)"portMapper must be specified");
        Assert.notNull((Object)this.portResolver, (String)"portResolver must be specified");
        URLEncoder.encode("   fzaef \u00e9& \u00e0 ", this.urlEncodingCharset);
    }

    public void commence(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        StringBuffer redirectUrl = new StringBuffer();
        HttpServletRequest req = (HttpServletRequest)request;
        if (this.isOutsideWebApp) {
            redirectUrl = redirectUrl.append(this.captchaFormUrl);
        } else {
            this.buildInternalRedirect(redirectUrl, req);
        }
        if (this.includeOriginalRequest) {
            this.includeOriginalRequest(redirectUrl, req);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Redirecting to: " + redirectUrl));
        }
        ((HttpServletResponse)response).sendRedirect(redirectUrl.toString());
    }

    private void buildInternalRedirect(StringBuffer redirectUrl, HttpServletRequest req) {
        StringBuffer simpleRedirect = new StringBuffer();
        String scheme = req.getScheme();
        String serverName = req.getServerName();
        int serverPort = this.portResolver.getServerPort((ServletRequest)req);
        String contextPath = req.getContextPath();
        boolean includePort = true;
        if ("http".equals(scheme.toLowerCase()) && serverPort == 80) {
            includePort = false;
        }
        if ("https".equals(scheme.toLowerCase()) && serverPort == 443) {
            includePort = false;
        }
        simpleRedirect.append(scheme);
        simpleRedirect.append("://");
        simpleRedirect.append(serverName);
        if (includePort) {
            simpleRedirect.append(":");
            simpleRedirect.append(serverPort);
        }
        simpleRedirect.append(contextPath);
        simpleRedirect.append(this.captchaFormUrl);
        if (this.forceHttps && req.getScheme().equals("http")) {
            Integer httpPort = new Integer(this.portResolver.getServerPort((ServletRequest)req));
            Integer httpsPort = this.portMapper.lookupHttpsPort(httpPort);
            if (httpsPort != null) {
                includePort = httpsPort != 443;
                redirectUrl.append("https://");
                redirectUrl.append(serverName);
                if (includePort) {
                    redirectUrl.append(":");
                    redirectUrl.append(httpsPort);
                }
                redirectUrl.append(contextPath);
                redirectUrl.append(this.captchaFormUrl);
            } else {
                redirectUrl.append(simpleRedirect);
            }
        } else {
            redirectUrl.append(simpleRedirect);
        }
    }

    private void includeOriginalRequest(StringBuffer redirectUrl, HttpServletRequest req) {
        if (redirectUrl.indexOf("?") >= 0) {
            redirectUrl.append("&");
        } else {
            redirectUrl.append("?");
        }
        redirectUrl.append(this.originalRequestUrlParameterName);
        redirectUrl.append("=");
        try {
            redirectUrl.append(URLEncoder.encode(req.getRequestURL().toString(), this.urlEncodingCharset));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn((Object)e);
        }
        redirectUrl.append("&");
        redirectUrl.append(this.originalRequestMethodParameterName);
        redirectUrl.append("=");
        redirectUrl.append(req.getMethod());
        if (this.includeOriginalParameters) {
            redirectUrl.append("&");
            redirectUrl.append(this.originalRequestParametersParameterName);
            redirectUrl.append("=");
            StringBuffer qp = new StringBuffer();
            Enumeration parameters = req.getParameterNames();
            if (parameters != null && parameters.hasMoreElements()) {
                while (parameters.hasMoreElements()) {
                    String name = parameters.nextElement().toString();
                    String value = req.getParameter(name);
                    qp.append(name);
                    qp.append(this.originalRequestParametersNameValueSeparator);
                    qp.append(value);
                    if (!parameters.hasMoreElements()) continue;
                    qp.append(this.originalRequestParametersSeparator);
                }
            }
            try {
                redirectUrl.append(URLEncoder.encode(qp.toString(), this.urlEncodingCharset));
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

