/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.acegisecurity.concurrent.SessionAlreadyUsedException;
import org.acegisecurity.concurrent.SessionInformation;
import org.acegisecurity.concurrent.SessionRegistry;
import org.acegisecurity.ui.session.HttpSessionDestroyedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.Assert;

public class SessionRegistryImpl
implements SessionRegistry,
ApplicationListener {
    private Map principals = Collections.synchronizedMap(new HashMap());
    private Map sessionIds = Collections.synchronizedMap(new HashMap());

    public SessionInformation[] getAllSessions(Object principal) {
        Set sessionsUsedByPrincipal = (Set)this.principals.get(principal);
        if (sessionsUsedByPrincipal == null) {
            return null;
        }
        ArrayList<SessionInformation> list = new ArrayList<SessionInformation>();
        Iterator iter = sessionsUsedByPrincipal.iterator();
        while (iter.hasNext()) {
            String sessionId = (String)iter.next();
            list.add(this.getSessionInformation(sessionId));
        }
        return list.toArray(new SessionInformation[0]);
    }

    public SessionInformation getSessionInformation(String sessionId) {
        Assert.hasText((String)sessionId, (String)"SessionId required as per interface contract");
        return (SessionInformation)this.sessionIds.get(sessionId);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof HttpSessionDestroyedEvent) {
            String sessionId = ((HttpSession)event.getSource()).getId();
            this.removeSessionInformation(sessionId);
        }
    }

    public void refreshLastRequest(String sessionId) {
        Assert.hasText((String)sessionId, (String)"SessionId required as per interface contract");
        SessionInformation info = this.getSessionInformation(sessionId);
        if (info != null) {
            info.refreshLastRequest();
        }
    }

    public void registerNewSession(String sessionId, Object principal) throws SessionAlreadyUsedException {
        Assert.hasText((String)sessionId, (String)"SessionId required as per interface contract");
        Assert.notNull((Object)principal, (String)"Principal required as per interface contract");
        if (this.getSessionInformation(sessionId) != null) {
            throw new SessionAlreadyUsedException("Session " + sessionId + " is already is use");
        }
        this.sessionIds.put(sessionId, new SessionInformation(principal, sessionId, new Date()));
        Set<String> sessionsUsedByPrincipal = (Set<String>)this.principals.get(principal);
        if (sessionsUsedByPrincipal == null) {
            sessionsUsedByPrincipal = Collections.synchronizedSet(new HashSet());
        }
        sessionsUsedByPrincipal.add(sessionId);
        this.principals.put(principal, sessionsUsedByPrincipal);
    }

    public void removeSessionInformation(String sessionId) {
        Assert.hasText((String)sessionId, (String)"SessionId required as per interface contract");
        SessionInformation info = this.getSessionInformation(sessionId);
        if (info != null) {
            this.sessionIds.remove(sessionId);
            Set sessionsUsedByPrincipal = (Set)this.principals.get(info.getPrincipal());
            if (sessionsUsedByPrincipal != null) {
                sessionsUsedByPrincipal.remove(sessionId);
                if (sessionsUsedByPrincipal.size() == 0) {
                    this.principals.remove(info.getPrincipal());
                }
            }
        }
    }

    public Object[] getAllPrincipals() {
        return this.principals.keySet().toArray();
    }
}

