/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.web;

import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.ConfigAttributeEditor;
import org.acegisecurity.intercept.web.AbstractFilterInvocationDefinitionSource;
import org.acegisecurity.intercept.web.PathBasedFilterInvocationDefinitionMap;
import org.acegisecurity.intercept.web.RegExpBasedFilterInvocationDefinitionMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class FilterInvocationDefinitionSourceEditor
extends PropertyEditorSupport {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$intercept$web$FilterInvocationDefinitionSourceEditor == null ? (class$org$acegisecurity$intercept$web$FilterInvocationDefinitionSourceEditor = FilterInvocationDefinitionSourceEditor.class$("org.acegisecurity.intercept.web.FilterInvocationDefinitionSourceEditor")) : class$org$acegisecurity$intercept$web$FilterInvocationDefinitionSourceEditor));
    static /* synthetic */ Class class$org$acegisecurity$intercept$web$FilterInvocationDefinitionSourceEditor;

    public void setAsText(String s) throws IllegalArgumentException {
        AbstractFilterInvocationDefinitionSource source = new RegExpBasedFilterInvocationDefinitionMap();
        if (s != null && !"".equals(s)) {
            if (s.lastIndexOf("PATTERN_TYPE_APACHE_ANT") != -1) {
                source = new PathBasedFilterInvocationDefinitionMap();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Detected PATTERN_TYPE_APACHE_ANT directive; using Apache Ant style path expressions");
                }
            }
            BufferedReader br = new BufferedReader(new StringReader(s));
            int counter = 0;
            while (true) {
                String line;
                ++counter;
                try {
                    line = br.readLine();
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException(ioe.getMessage());
                }
                if (line == null) break;
                line = line.trim();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Line " + counter + ": " + line));
                }
                if (line.startsWith("//")) continue;
                if (line.equals("CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON")) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Line " + counter + ": Instructing mapper to convert URLs to lowercase before comparison"));
                    }
                    source.setConvertUrlToLowercaseBeforeComparison(true);
                    continue;
                }
                if (line.lastIndexOf(61) == -1) continue;
                String[] nameValue = StringUtils.delimitedListToStringArray((String)line, (String)"=");
                String name = nameValue[0];
                String value = nameValue[1];
                if (!StringUtils.hasLength((String)name) || !StringUtils.hasLength((String)value)) {
                    throw new IllegalArgumentException("Failed to parse a valid name/value pair from " + line);
                }
                ConfigAttributeEditor configAttribEd = new ConfigAttributeEditor();
                configAttribEd.setAsText(value);
                ConfigAttributeDefinition attr = (ConfigAttributeDefinition)configAttribEd.getValue();
                source.addSecureUrl(name, attr);
            }
        }
        this.setValue(source);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

