/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers;

import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.UserDetails;
import org.springframework.util.Assert;

public abstract class AbstractAuthenticationToken
implements Authentication {
    private Object details;
    private GrantedAuthority[] authorities;
    private boolean authenticated = false;

    public AbstractAuthenticationToken() {
    }

    public AbstractAuthenticationToken(GrantedAuthority[] authorities) {
        if (authorities != null) {
            for (int i = 0; i < authorities.length; ++i) {
                Assert.notNull((Object)authorities[i], (String)("Granted authority element " + i + " is null - GrantedAuthority[] cannot contain any null elements"));
            }
        }
        this.authorities = authorities;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractAuthenticationToken) {
            AbstractAuthenticationToken test = (AbstractAuthenticationToken)obj;
            if (this.getAuthorities() != null || test.getAuthorities() != null) {
                if (this.getAuthorities() == null || test.getAuthorities() == null) {
                    return false;
                }
                if (this.getAuthorities().length != test.getAuthorities().length) {
                    return false;
                }
                for (int i = 0; i < this.getAuthorities().length; ++i) {
                    if (this.getAuthorities()[i].equals(test.getAuthorities()[i])) continue;
                    return false;
                }
            }
            if (this.details == null && test.getDetails() != null) {
                return false;
            }
            if (this.details != null && test.getDetails() == null) {
                return false;
            }
            if (this.details != null && !this.details.equals(test.getDetails())) {
                return false;
            }
            return this.getPrincipal().equals(test.getPrincipal()) && this.getCredentials().equals(test.getCredentials()) && this.isAuthenticated() == test.isAuthenticated();
        }
        return false;
    }

    public GrantedAuthority[] getAuthorities() {
        if (this.authorities == null) {
            return null;
        }
        GrantedAuthority[] copy = new GrantedAuthority[this.authorities.length];
        System.arraycopy(this.authorities, 0, copy, 0, this.authorities.length);
        return copy;
    }

    public Object getDetails() {
        return this.details;
    }

    public String getName() {
        if (this.getPrincipal() instanceof UserDetails) {
            return ((UserDetails)this.getPrincipal()).getUsername();
        }
        return this.getPrincipal().toString();
    }

    public int hashCode() {
        int code = 2305;
        if (this.getAuthorities() != null) {
            for (int i = 0; i < this.getAuthorities().length; ++i) {
                code *= this.getAuthorities()[i].hashCode() % 7;
            }
        }
        if (this.getPrincipal() != null) {
            code *= this.getPrincipal().hashCode() % 7;
        }
        if (this.getCredentials() != null) {
            code *= this.getCredentials().hashCode() % 7;
        }
        if (this.getDetails() != null) {
            code *= this.getDetails().hashCode() % 7;
        }
        if (this.isAuthenticated()) {
            code *= -3;
        }
        return code;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public void setDetails(Object details) {
        this.details = details;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append(": ");
        sb.append("Username: ").append(this.getPrincipal()).append("; ");
        sb.append("Password: [PROTECTED]; ");
        sb.append("Authenticated: ").append(this.isAuthenticated()).append("; ");
        sb.append("Details: ").append(this.getDetails()).append("; ");
        if (this.getAuthorities() != null) {
            sb.append("Granted Authorities: ");
            for (int i = 0; i < this.getAuthorities().length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getAuthorities()[i].toString());
            }
        } else {
            sb.append("Not granted any authorities");
        }
        return sb.toString();
    }
}

