/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.ldap;

import javax.naming.directory.Attributes;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.dao.AbstractUserDetailsAuthenticationProvider;
import org.acegisecurity.providers.ldap.LdapAuthenticator;
import org.acegisecurity.providers.ldap.LdapAuthoritiesPopulator;
import org.acegisecurity.providers.ldap.LdapUserInfo;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class LdapAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$providers$ldap$LdapAuthenticationProvider == null ? (class$org$acegisecurity$providers$ldap$LdapAuthenticationProvider = LdapAuthenticationProvider.class$("org.acegisecurity.providers.ldap.LdapAuthenticationProvider")) : class$org$acegisecurity$providers$ldap$LdapAuthenticationProvider));
    private LdapAuthenticator authenticator;
    private LdapAuthoritiesPopulator authoritiesPopulator;
    static /* synthetic */ Class class$org$acegisecurity$providers$ldap$LdapAuthenticationProvider;

    public LdapAuthenticationProvider(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator) {
        Assert.notNull((Object)authenticator, (String)"An LdapAuthenticator must be supplied");
        Assert.notNull((Object)authoritiesPopulator, (String)"An LdapAuthoritiesPopulator must be supplied");
        this.authenticator = authenticator;
        this.authoritiesPopulator = authoritiesPopulator;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieving user " + username));
        }
        String password = (String)authentication.getCredentials();
        Assert.hasLength((String)password, (String)"Null or empty password was supplied in authentication token");
        LdapUserInfo ldapUser = this.authenticator.authenticate(username, password);
        return this.createUserDetails(username, password, ldapUser.getDn(), ldapUser.getAttributes());
    }

    protected UserDetails createUserDetails(String username, String password, String userDn, Attributes attributes) {
        return new User(username, password, true, true, true, true, this.authoritiesPopulator.getGrantedAuthorities(username, userDn, attributes));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

