/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.ldap.authenticator;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.acegisecurity.AcegiMessageSource;
import org.acegisecurity.providers.ldap.InitialDirContextFactory;
import org.acegisecurity.providers.ldap.LdapAuthenticator;
import org.acegisecurity.providers.ldap.LdapUserSearch;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.util.Assert;

public abstract class AbstractLdapAuthenticator
implements LdapAuthenticator,
InitializingBean,
MessageSourceAware {
    protected MessageSourceAccessor messages = AcegiMessageSource.getAccessor();
    private InitialDirContextFactory initialDirContextFactory;
    private MessageFormat[] userDnFormat = null;
    private LdapUserSearch userSearch;
    private String[] userAttributes = null;
    private String dnSuffix = "";

    protected AbstractLdapAuthenticator(InitialDirContextFactory initialDirContextFactory) {
        Assert.notNull((Object)initialDirContextFactory, (String)"initialDirContextFactory must not be null.");
        this.initialDirContextFactory = initialDirContextFactory;
        String rootDn = initialDirContextFactory.getRootDn();
        if (rootDn.length() > 0) {
            this.dnSuffix = "," + rootDn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getUserDns(String username) {
        if (this.userDnFormat == null) {
            return new ArrayList(0);
        }
        ArrayList<String> userDns = new ArrayList<String>(this.userDnFormat.length);
        String[] args = new String[]{username};
        MessageFormat[] messageFormatArray = this.userDnFormat;
        synchronized (this.userDnFormat) {
            for (int i = 0; i < this.userDnFormat.length; ++i) {
                userDns.add(this.userDnFormat[i].format(args) + this.dnSuffix);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return userDns;
        }
    }

    public void setUserDnPatterns(String[] dnPattern) {
        Assert.notNull((Object)dnPattern, (String)"The array of DN patterns cannot be set to null");
        this.userDnFormat = new MessageFormat[dnPattern.length];
        for (int i = 0; i < dnPattern.length; ++i) {
            this.userDnFormat[i] = new MessageFormat(dnPattern[i]);
        }
    }

    public void setUserAttributes(String[] userAttributes) {
        Assert.notNull((Object)userAttributes, (String)"The userAttributes property cannot be set to null");
        this.userAttributes = userAttributes;
    }

    public String[] getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserSearch(LdapUserSearch userSearch) {
        Assert.notNull((Object)userSearch, (String)"The userSearch cannot be set to null");
        this.userSearch = userSearch;
    }

    protected LdapUserSearch getUserSearch() {
        return this.userSearch;
    }

    protected InitialDirContextFactory getInitialDirContextFactory() {
        return this.initialDirContextFactory;
    }

    public void setMessageSource(MessageSource messageSource) {
        Assert.notNull((Object)"Message source must not be null");
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((this.userDnFormat != null || this.userSearch != null ? 1 : 0) != 0, (String)"Either an LdapUserSearch or DN pattern (or both) must be supplied.");
    }
}

