/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.ldap.authenticator;

import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.providers.ldap.InitialDirContextFactory;
import org.acegisecurity.providers.ldap.LdapDataAccessException;
import org.acegisecurity.providers.ldap.LdapUserInfo;
import org.acegisecurity.providers.ldap.LdapUtils;
import org.acegisecurity.providers.ldap.authenticator.AbstractLdapAuthenticator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BindAuthenticator
extends AbstractLdapAuthenticator {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$providers$ldap$authenticator$BindAuthenticator == null ? (class$org$acegisecurity$providers$ldap$authenticator$BindAuthenticator = BindAuthenticator.class$("org.acegisecurity.providers.ldap.authenticator.BindAuthenticator")) : class$org$acegisecurity$providers$ldap$authenticator$BindAuthenticator));
    static /* synthetic */ Class class$org$acegisecurity$providers$ldap$authenticator$BindAuthenticator;

    public BindAuthenticator(InitialDirContextFactory initialDirContextFactory) {
        super(initialDirContextFactory);
    }

    public LdapUserInfo authenticate(String username, String password) {
        LdapUserInfo user = null;
        Iterator dns = this.getUserDns(username).iterator();
        while (dns.hasNext() && user == null) {
            user = this.bindWithDn((String)dns.next(), password);
        }
        if (user == null && this.getUserSearch() != null) {
            LdapUserInfo userFromSearch = this.getUserSearch().searchForUser(username);
            user = this.bindWithDn(userFromSearch.getDn(), password);
        }
        if (user == null) {
            throw new BadCredentialsException(this.messages.getMessage("BindAuthenticator.badCredentials", "Bad credentials"));
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LdapUserInfo bindWithDn(String userDn, String password) {
        DirContext ctx = null;
        LdapUserInfo user = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempting to bind with DN = " + userDn));
        }
        try {
            ctx = this.getInitialDirContextFactory().newInitialDirContext(userDn, password);
            Attributes attributes = this.loadAttributes(ctx, userDn);
            user = new LdapUserInfo(userDn, attributes);
        }
        catch (BadCredentialsException e) {
            block5: {
                try {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)("Failed to bind as " + userDn + ": " + e.getCause()));
                }
                catch (Throwable throwable) {
                    LdapUtils.closeContext(ctx);
                    throw throwable;
                }
            }
            LdapUtils.closeContext(ctx);
        }
        LdapUtils.closeContext(ctx);
        return user;
    }

    Attributes loadAttributes(DirContext ctx, String userDn) {
        try {
            return ctx.getAttributes(LdapUtils.getRelativeName(userDn, ctx), this.getUserAttributes());
        }
        catch (NamingException ne) {
            throw new LdapDataAccessException(this.messages.getMessage("BindAuthenticator.failedToLoadAttributes", (Object[])new String[]{userDn}, "Failed to load attributes for user {0}"), ne);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

