/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.ldap.authenticator;

import java.util.Iterator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.providers.encoding.PasswordEncoder;
import org.acegisecurity.providers.ldap.InitialDirContextFactory;
import org.acegisecurity.providers.ldap.LdapUserInfo;
import org.acegisecurity.providers.ldap.LdapUtils;
import org.acegisecurity.providers.ldap.authenticator.AbstractLdapAuthenticator;
import org.acegisecurity.providers.ldap.authenticator.LdapShaPasswordEncoder;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public final class PasswordComparisonAuthenticator
extends AbstractLdapAuthenticator {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$providers$ldap$authenticator$PasswordComparisonAuthenticator == null ? (class$org$acegisecurity$providers$ldap$authenticator$PasswordComparisonAuthenticator = PasswordComparisonAuthenticator.class$("org.acegisecurity.providers.ldap.authenticator.PasswordComparisonAuthenticator")) : class$org$acegisecurity$providers$ldap$authenticator$PasswordComparisonAuthenticator));
    private static final String[] NO_ATTRS = new String[0];
    private String passwordAttributeName = "userPassword";
    private String passwordCompareFilter = "(userPassword={0})";
    private PasswordEncoder passwordEncoder = new LdapShaPasswordEncoder();
    static /* synthetic */ Class class$org$acegisecurity$providers$ldap$authenticator$PasswordComparisonAuthenticator;

    public PasswordComparisonAuthenticator(InitialDirContextFactory initialDirContextFactory) {
        super(initialDirContextFactory);
    }

    public LdapUserInfo authenticate(String username, String password) {
        LdapUserInfo user = null;
        DirContext ctx = this.getInitialDirContextFactory().newInitialDirContext();
        Iterator dns = this.getUserDns(username).iterator();
        try {
            while (dns.hasNext() && user == null) {
                String userDn = (String)dns.next();
                String relativeName = LdapUtils.getRelativeName(userDn, ctx);
                user = new LdapUserInfo(userDn, ctx.getAttributes(relativeName, this.getUserAttributes()));
            }
            if (user == null && this.getUserSearch() != null) {
                user = this.getUserSearch().searchForUser(username);
            }
            if (user == null) {
                throw new UsernameNotFoundException(username);
            }
            Attribute passwordAttribute = user.getAttributes().get(this.passwordAttributeName);
            if (passwordAttribute != null) {
                Object retrievedPassword = passwordAttribute.get();
                if (!(retrievedPassword instanceof String)) {
                    retrievedPassword = new String((byte[])retrievedPassword);
                }
                if (!this.verifyPassword(password, (String)retrievedPassword)) {
                    throw new BadCredentialsException(this.messages.getMessage("PasswordComparisonAuthenticator.badCredentials", "Bad credentials"));
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Password attribute " + this.passwordAttributeName + " wasn't retrieved for user " + username));
                }
                this.doPasswordCompare(ctx, user.getRelativeName(ctx), password);
            }
            LdapUserInfo ldapUserInfo = user;
            return ldapUserInfo;
        }
        catch (NamingException ne) {
            throw new BadCredentialsException("Authentication failed due to exception ", ne);
        }
        finally {
            LdapUtils.closeContext(ctx);
        }
    }

    private boolean verifyPassword(String password, String ldapPassword) {
        if (ldapPassword.equals(password)) {
            return true;
        }
        return this.passwordEncoder.isPasswordValid(ldapPassword, password, null);
    }

    private void doPasswordCompare(DirContext ctx, String name, String password) throws NamingException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Performing LDAP compare of password for " + name));
        }
        password = this.passwordEncoder.encodePassword(password, null);
        byte[] passwordBytes = LdapUtils.getUtf8Bytes(password);
        SearchControls ctls = new SearchControls();
        ctls.setReturningAttributes(NO_ATTRS);
        ctls.setSearchScope(0);
        NamingEnumeration<SearchResult> results = ctx.search(name, this.passwordCompareFilter, new Object[]{passwordBytes}, ctls);
        if (!results.hasMore()) {
            throw new BadCredentialsException(this.messages.getMessage("PasswordComparisonAuthenticator.badCredentials", "Bad credentials"));
        }
    }

    public void setPasswordAttributeName(String passwordAttribute) {
        Assert.hasLength((String)passwordAttribute, (String)"passwordAttributeName must not be empty or null");
        this.passwordAttributeName = passwordAttribute;
        this.passwordCompareFilter = "(" + this.passwordAttributeName + "={0})";
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        Assert.notNull((Object)passwordEncoder, (String)"passwordEncoder must not be null.");
        this.passwordEncoder = passwordEncoder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

