/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.ldap.populator;

import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.ldap.InitialDirContextFactory;
import org.acegisecurity.providers.ldap.LdapAuthoritiesPopulator;
import org.acegisecurity.providers.ldap.LdapDataAccessException;
import org.acegisecurity.providers.ldap.LdapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class DefaultLdapAuthoritiesPopulator
implements LdapAuthoritiesPopulator {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$providers$ldap$populator$DefaultLdapAuthoritiesPopulator == null ? (class$org$acegisecurity$providers$ldap$populator$DefaultLdapAuthoritiesPopulator = DefaultLdapAuthoritiesPopulator.class$("org.acegisecurity.providers.ldap.populator.DefaultLdapAuthoritiesPopulator")) : class$org$acegisecurity$providers$ldap$populator$DefaultLdapAuthoritiesPopulator));
    private String[] userRoleAttributes = null;
    private String rolePrefix = "ROLE_";
    private String groupSearchBase = null;
    private String groupSearchFilter = "(member={0})";
    private String groupRoleAttribute = "cn";
    private int searchScope = 1;
    private boolean convertToUpperCase = true;
    private GrantedAuthority defaultRole = null;
    private InitialDirContextFactory initialDirContextFactory = null;
    static /* synthetic */ Class class$org$acegisecurity$providers$ldap$populator$DefaultLdapAuthoritiesPopulator;

    public DefaultLdapAuthoritiesPopulator() {
    }

    public DefaultLdapAuthoritiesPopulator(InitialDirContextFactory initialDirContextFactory, String groupSearchBase) {
        Assert.notNull((Object)initialDirContextFactory, (String)"InitialDirContextFactory must not be null");
        Assert.hasLength((String)groupSearchBase, (String)"The groupSearchBase (name to search under), must be specified.");
        this.initialDirContextFactory = initialDirContextFactory;
        this.groupSearchBase = groupSearchBase;
    }

    public GrantedAuthority[] getGrantedAuthorities(String username, String userDn, Attributes userAttributes) {
        logger.debug((Object)("Getting authorities for user " + userDn));
        Set roles = this.getRolesFromUserAttributes(userDn, userAttributes);
        Set groupRoles = this.getGroupMembershipRoles(userDn, userAttributes);
        if (groupRoles != null) {
            roles.addAll(groupRoles);
        }
        if (this.defaultRole != null) {
            roles.add(this.defaultRole);
        }
        return roles.toArray(new GrantedAuthority[roles.size()]);
    }

    protected Set getRolesFromUserAttributes(String userDn, Attributes userAttributes) {
        HashSet userRoles = new HashSet();
        for (int i = 0; this.userRoleAttributes != null && i < this.userRoleAttributes.length; ++i) {
            Attribute roleAttribute = userAttributes.get(this.userRoleAttributes[i]);
            this.addAttributeValuesToRoleSet(roleAttribute, userRoles);
        }
        return userRoles;
    }

    protected Set getGroupMembershipRoles(String userDn, Attributes userAttributes) {
        HashSet userRoles = new HashSet();
        if (this.groupSearchBase == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for roles for user '" + userDn + "', with filter " + this.groupSearchFilter + " in search base '" + this.groupSearchBase + "'"));
        }
        DirContext ctx = this.initialDirContextFactory.newInitialDirContext();
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(this.searchScope);
        ctls.setReturningAttributes(new String[]{this.groupRoleAttribute});
        try {
            NamingEnumeration<SearchResult> groups = ctx.search(this.groupSearchBase, this.groupSearchFilter, (Object[])new String[]{userDn}, ctls);
            while (groups.hasMore()) {
                SearchResult result = groups.next();
                Attributes attrs = result.getAttributes();
                NamingEnumeration<? extends Attribute> groupRoleAttributes = attrs.getAll();
                while (groupRoleAttributes.hasMore()) {
                    Attribute roleAttribute = groupRoleAttributes.next();
                    this.addAttributeValuesToRoleSet(roleAttribute, userRoles);
                }
            }
        }
        catch (NamingException e) {
            throw new LdapDataAccessException("Group search failed for user " + userDn, e);
        }
        finally {
            LdapUtils.closeContext(ctx);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Roles from search: " + userRoles));
        }
        return userRoles;
    }

    private void addAttributeValuesToRoleSet(Attribute roleAttribute, Set roles) {
        if (roleAttribute == null) {
            return;
        }
        try {
            NamingEnumeration<?> attributeRoles = roleAttribute.getAll();
            while (attributeRoles.hasMore()) {
                Object role = attributeRoles.next();
                if (role instanceof String) {
                    if (this.convertToUpperCase) {
                        role = ((String)role).toUpperCase();
                    }
                    roles.add(new GrantedAuthorityImpl(this.rolePrefix + role));
                    continue;
                }
                logger.warn((Object)("Non-String value found for role attribute " + roleAttribute.getID()));
            }
        }
        catch (NamingException ne) {
            throw new LdapDataAccessException("Error retrieving values for role attribute " + roleAttribute.getID(), ne);
        }
    }

    protected String[] getUserRoleAttributes() {
        return this.userRoleAttributes;
    }

    public void setUserRoleAttributes(String[] userRoleAttributes) {
        this.userRoleAttributes = userRoleAttributes;
    }

    public void setRolePrefix(String rolePrefix) {
        Assert.notNull((Object)rolePrefix, (String)"rolePrefix must not be null");
        this.rolePrefix = rolePrefix;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        Assert.notNull((Object)groupSearchFilter, (String)"groupSearchFilter must not be null");
        this.groupSearchFilter = groupSearchFilter;
    }

    public void setGroupRoleAttribute(String groupRoleAttribute) {
        Assert.notNull((Object)groupRoleAttribute, (String)"groupRoleAttribute must not be null");
        this.groupRoleAttribute = groupRoleAttribute;
    }

    public void setSearchSubtree(boolean searchSubtree) {
        this.searchScope = searchSubtree ? 2 : 1;
    }

    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }

    public void setDefaultRole(String defaultRole) {
        Assert.notNull((Object)defaultRole, (String)"The defaultRole property cannot be set to null");
        this.defaultRole = new GrantedAuthorityImpl(defaultRole);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

