/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.ldap.search;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.providers.ldap.InitialDirContextFactory;
import org.acegisecurity.providers.ldap.LdapDataAccessException;
import org.acegisecurity.providers.ldap.LdapUserInfo;
import org.acegisecurity.providers.ldap.LdapUserSearch;
import org.acegisecurity.providers.ldap.LdapUtils;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class FilterBasedLdapUserSearch
implements LdapUserSearch {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$providers$ldap$search$FilterBasedLdapUserSearch == null ? (class$org$acegisecurity$providers$ldap$search$FilterBasedLdapUserSearch = FilterBasedLdapUserSearch.class$("org.acegisecurity.providers.ldap.search.FilterBasedLdapUserSearch")) : class$org$acegisecurity$providers$ldap$search$FilterBasedLdapUserSearch));
    private String searchBase = "";
    private int searchScope = 1;
    private String searchFilter;
    private int searchTimeLimit = 0;
    private InitialDirContextFactory initialDirContextFactory;
    static /* synthetic */ Class class$org$acegisecurity$providers$ldap$search$FilterBasedLdapUserSearch;

    public FilterBasedLdapUserSearch(String searchBase, String searchFilter, InitialDirContextFactory initialDirContextFactory) {
        Assert.notNull((Object)initialDirContextFactory, (String)"initialDirContextFactory must not be null");
        Assert.notNull((Object)searchFilter, (String)"searchFilter must not be null.");
        Assert.notNull((Object)searchBase, (String)"searchBase must not be null (an empty string is acceptable).");
        this.searchFilter = searchFilter;
        this.initialDirContextFactory = initialDirContextFactory;
        this.searchBase = searchBase;
        if (searchBase.length() == 0) {
            logger.info((Object)("SearchBase not set. Searches will be performed from the root: " + initialDirContextFactory.getRootDn()));
        }
    }

    public LdapUserInfo searchForUser(String username) {
        DirContext ctx = this.initialDirContextFactory.newInitialDirContext();
        SearchControls ctls = new SearchControls();
        ctls.setTimeLimit(this.searchTimeLimit);
        ctls.setSearchScope(this.searchScope);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for user '" + username + "', in context " + ctx + ", with user search " + this.toString()));
        }
        try {
            Object[] args = new String[]{LdapUtils.escapeNameForFilter(username)};
            NamingEnumeration<SearchResult> results = ctx.search(this.searchBase, this.searchFilter, args, ctls);
            if (!results.hasMore()) {
                throw new UsernameNotFoundException("User " + username + " not found in directory.");
            }
            SearchResult searchResult = results.next();
            if (results.hasMore()) {
                throw new BadCredentialsException("Expected a single user but search returned multiple results");
            }
            StringBuffer userDn = new StringBuffer(searchResult.getName());
            if (this.searchBase.length() > 0) {
                userDn.append(",");
                userDn.append(this.searchBase);
            }
            userDn.append(",");
            userDn.append(ctx.getNameInNamespace());
            LdapUserInfo ldapUserInfo = new LdapUserInfo(userDn.toString(), searchResult.getAttributes());
            return ldapUserInfo;
        }
        catch (NamingException ne) {
            throw new LdapDataAccessException("User Couldn't be found due to exception", ne);
        }
        finally {
            LdapUtils.closeContext(ctx);
        }
    }

    public void setSearchSubtree(boolean searchSubtree) {
        this.searchScope = searchSubtree ? 2 : 1;
    }

    public void setSearchTimeLimit(int searchTimeLimit) {
        this.searchTimeLimit = searchTimeLimit;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ searchFilter: '").append(this.searchFilter).append("', ");
        sb.append("searchBase: '").append(this.searchBase).append("'");
        sb.append(", scope: ").append(this.searchScope == 2 ? "subtree" : "single-level, ");
        sb.append("searchTimeLimit: ").append(this.searchTimeLimit).append(" ]");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

