/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationTrustResolver;
import org.acegisecurity.AuthenticationTrustResolverImpl;
import org.acegisecurity.InsufficientAuthenticationException;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.intercept.web.FilterInvocation;
import org.acegisecurity.ui.AuthenticationEntryPoint;
import org.acegisecurity.util.PortResolver;
import org.acegisecurity.util.PortResolverImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ExceptionTranslationFilter
implements Filter,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$ui$ExceptionTranslationFilter == null ? (class$org$acegisecurity$ui$ExceptionTranslationFilter = ExceptionTranslationFilter.class$("org.acegisecurity.ui.ExceptionTranslationFilter")) : class$org$acegisecurity$ui$ExceptionTranslationFilter));
    public static final String ACEGI_SECURITY_ACCESS_DENIED_EXCEPTION_KEY = "ACEGI_SECURITY_403_EXCEPTION";
    private AuthenticationEntryPoint authenticationEntryPoint;
    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();
    private PortResolver portResolver = new PortResolverImpl();
    private boolean createSessionAllowed = true;
    static /* synthetic */ Class class$org$acegisecurity$ui$ExceptionTranslationFilter;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationEntryPoint, (String)"authenticationEntryPoint must be specified");
        Assert.notNull((Object)this.portResolver, (String)"portResolver must be specified");
        Assert.notNull((Object)this.authenticationTrustResolver, (String)"authenticationTrustResolver must be specified");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("HttpServletRequest required");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("HttpServletResponse required");
        }
        try {
            chain.doFilter(request, response);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Chain processed normally");
            }
        }
        catch (AuthenticationException authentication) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Authentication exception occurred; redirecting to authentication entry point", (Throwable)((Object)authentication));
            }
            this.sendStartAuthentication(request, response, chain, authentication);
        }
        catch (AccessDeniedException accessDenied) {
            if (this.authenticationTrustResolver.isAnonymous(SecurityContextHolder.getContext().getAuthentication())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Access is denied (user is anonymous); redirecting to authentication entry point", (Throwable)((Object)accessDenied));
                }
                this.sendStartAuthentication(request, response, chain, new InsufficientAuthenticationException("Full authentication is required to access this resource"));
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Access is denied (user is not anonymous); sending back forbidden response", (Throwable)((Object)accessDenied));
                }
                this.sendAccessDeniedError(request, response, chain, accessDenied);
            }
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable otherException) {
            throw new ServletException(otherException);
        }
    }

    public AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return this.authenticationEntryPoint;
    }

    public AuthenticationTrustResolver getAuthenticationTrustResolver() {
        return this.authenticationTrustResolver;
    }

    public PortResolver getPortResolver() {
        return this.portResolver;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public boolean isCreateSessionAllowed() {
        return this.createSessionAllowed;
    }

    protected void sendAccessDeniedError(ServletRequest request, ServletResponse response, FilterChain chain, AccessDeniedException accessDenied) throws ServletException, IOException {
        if (this.createSessionAllowed) {
            ((HttpServletRequest)request).getSession().setAttribute(ACEGI_SECURITY_ACCESS_DENIED_EXCEPTION_KEY, (Object)accessDenied);
        }
        ((HttpServletResponse)response).sendError(403, accessDenied.getMessage());
    }

    protected void sendStartAuthentication(ServletRequest request, ServletResponse response, FilterChain chain, AuthenticationException reason) throws ServletException, IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        int port = this.portResolver.getServerPort((ServletRequest)httpRequest);
        boolean includePort = true;
        if ("http".equals(httpRequest.getScheme().toLowerCase()) && port == 80) {
            includePort = false;
        }
        if ("https".equals(httpRequest.getScheme().toLowerCase()) && port == 443) {
            includePort = false;
        }
        String targetUrl = httpRequest.getScheme() + "://" + httpRequest.getServerName() + (includePort ? ":" + port : "") + httpRequest.getContextPath() + new FilterInvocation(request, response, chain).getRequestUrl();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authentication entry point being called; target URL added to Session: " + targetUrl));
        }
        if (this.createSessionAllowed) {
            httpRequest.getSession().setAttribute("ACEGI_SECURITY_TARGET_URL", (Object)targetUrl);
        }
        SecurityContextHolder.getContext().setAuthentication(null);
        this.authenticationEntryPoint.commence((ServletRequest)httpRequest, (ServletResponse)((HttpServletResponse)response), reason);
    }

    public void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setAuthenticationTrustResolver(AuthenticationTrustResolver authenticationTrustResolver) {
        this.authenticationTrustResolver = authenticationTrustResolver;
    }

    public void setCreateSessionAllowed(boolean createSessionAllowed) {
        this.createSessionAllowed = createSessionAllowed;
    }

    public void setPortResolver(PortResolver portResolver) {
        this.portResolver = portResolver;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

