/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.webapp;

import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.ui.WebAuthenticationDetails;
import org.acegisecurity.ui.webapp.AuthenticationProcessingFilter;

public class SiteminderAuthenticationProcessingFilter
extends AuthenticationProcessingFilter {
    private String formPasswordParameterKey = null;
    private String formUsernameParameterKey = null;
    private String siteminderPasswordHeaderKey = null;
    private String siteminderUsernameHeaderKey = null;

    public Authentication attemptAuthentication(HttpServletRequest request) throws AuthenticationException {
        String username = null;
        String password = null;
        if (this.siteminderUsernameHeaderKey != null && this.siteminderUsernameHeaderKey.length() > 0 && this.siteminderPasswordHeaderKey != null && this.siteminderPasswordHeaderKey.length() > 0) {
            username = request.getHeader(this.siteminderUsernameHeaderKey);
            password = request.getHeader(this.siteminderPasswordHeaderKey);
        }
        if (username == null || username.length() == 0 || password == null || password.length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Siteminder headers not found for authentication, so trying to use form values");
            }
            username = this.formUsernameParameterKey != null && this.formUsernameParameterKey.length() > 0 ? request.getParameter(this.formUsernameParameterKey) : request.getParameter("j_username");
            password = this.obtainPassword(request);
        }
        username = username != null ? username.toUpperCase() : "";
        password = password != null ? password.toUpperCase() : "";
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken(username, password);
        this.setDetails(request, authRequest);
        request.getSession().setAttribute("ACEGI_SECURITY_LAST_USERNAME", (Object)username);
        return this.getAuthenticationManager().authenticate(authRequest);
    }

    public String getDefaultFilterProcessesUrl() {
        return "/j_acegi_security_check";
    }

    public String getFormPasswordParameterKey() {
        return this.formPasswordParameterKey;
    }

    public String getFormUsernameParameterKey() {
        return this.formUsernameParameterKey;
    }

    public String getSiteminderPasswordHeaderKey() {
        return this.siteminderPasswordHeaderKey;
    }

    public String getSiteminderUsernameHeaderKey() {
        return this.siteminderUsernameHeaderKey;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    protected String obtainPassword(HttpServletRequest request) {
        if (this.formPasswordParameterKey != null && this.formPasswordParameterKey.length() > 0) {
            return request.getParameter(this.formPasswordParameterKey);
        }
        return request.getParameter("j_password");
    }

    protected void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authRequest) {
        authRequest.setDetails(new WebAuthenticationDetails(request));
    }

    public void setFormPasswordParameterKey(String key) {
        this.formPasswordParameterKey = key;
    }

    public void setFormUsernameParameterKey(String key) {
        this.formUsernameParameterKey = key;
    }

    public void setSiteminderPasswordHeaderKey(String key) {
        this.siteminderPasswordHeaderKey = key;
    }

    public void setSiteminderUsernameHeaderKey(String key) {
        this.siteminderUsernameHeaderKey = key;
    }
}

