/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.wrapper;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationTrustResolver;
import org.acegisecurity.AuthenticationTrustResolverImpl;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.userdetails.UserDetails;

public class SecurityContextHolderAwareRequestWrapper
extends HttpServletRequestWrapper {
    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();

    public SecurityContextHolderAwareRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String getRemoteUser() {
        Authentication auth = this.getAuthentication();
        if (auth == null || auth.getPrincipal() == null) {
            return null;
        }
        if (auth.getPrincipal() instanceof UserDetails) {
            return ((UserDetails)auth.getPrincipal()).getUsername();
        }
        return auth.getPrincipal().toString();
    }

    public boolean isUserInRole(String role) {
        return this.isGranted(role);
    }

    public Principal getUserPrincipal() {
        Authentication auth = this.getAuthentication();
        if (auth == null || auth.getPrincipal() == null) {
            return null;
        }
        return auth;
    }

    private Authentication getAuthentication() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (!this.authenticationTrustResolver.isAnonymous(auth)) {
            return auth;
        }
        return null;
    }

    private boolean isGranted(String role) {
        Authentication auth = this.getAuthentication();
        if (auth == null || auth.getPrincipal() == null || auth.getAuthorities() == null) {
            return false;
        }
        for (int i = 0; i < auth.getAuthorities().length; ++i) {
            if (!role.equals(auth.getAuthorities()[i].getAuthority())) continue;
            return true;
        }
        return false;
    }
}

