/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.security;

import java.util.ArrayList;
import org.activiti.app.security.ActivitiAppUser;
import org.activiti.app.security.CustomUserDetailService;
import org.activiti.app.service.api.UserCache;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.activiti.engine.impl.identity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.transaction.annotation.Transactional;

public class UserDetailsService
implements org.springframework.security.core.userdetails.UserDetailsService,
CustomUserDetailService {
    @Autowired
    private UserCache userCache;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private Environment env;
    private long userValidityPeriod;

    @Override
    @Transactional
    public UserDetails loadUserByUsername(String login) {
        String actualLogin = login;
        User userFromDatabase = null;
        userFromDatabase = (User)this.identityService.createUserQuery().userId(actualLogin).singleResult();
        if (userFromDatabase == null) {
            throw new UsernameNotFoundException("User " + actualLogin + " was not found in the database");
        }
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        grantedAuthorities.add(new SimpleGrantedAuthority("ROLE_USER"));
        String superUserGroupName = this.env.getRequiredProperty("admin.group");
        for (Group group : this.identityService.createGroupQuery().groupMember(userFromDatabase.getId()).list()) {
            if (!StringUtils.equals((CharSequence)superUserGroupName, (CharSequence)group.getName())) continue;
            grantedAuthorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"));
        }
        this.userCache.putUser(userFromDatabase.getId(), new UserCache.CachedUser(userFromDatabase, grantedAuthorities));
        Authentication.setAuthenticatedUserId((String)String.valueOf(userFromDatabase.getId()));
        return new ActivitiAppUser(userFromDatabase, actualLogin, grantedAuthorities);
    }

    @Override
    @Transactional
    public UserDetails loadByUserId(String userId) {
        UserCache.CachedUser cachedUser = this.userCache.getUser(userId, true, true, false);
        if (cachedUser == null) {
            throw new UsernameNotFoundException("User " + userId + " was not found in the database");
        }
        long lastDatabaseCheck = cachedUser.getLastDatabaseCheck();
        long currentTime = System.currentTimeMillis();
        if (this.userValidityPeriod <= 0L || currentTime - lastDatabaseCheck >= this.userValidityPeriod) {
            this.userCache.invalidate(userId);
            cachedUser = this.userCache.getUser(userId, true, true, false);
            cachedUser.setLastDatabaseCheck(currentTime);
        }
        User user = cachedUser.getUser();
        String actualUserId = user.getEmail();
        Authentication.setAuthenticatedUserId((String)String.valueOf(user.getId()));
        return new ActivitiAppUser(cachedUser.getUser(), actualUserId, cachedUser.getGrantedAuthorities());
    }

    public void setUserValidityPeriod(long userValidityPeriod) {
        this.userValidityPeriod = userValidityPeriod;
    }
}

