/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.web;

import org.activiti.app.web.CustomAntPathMatcher;
import org.activiti.app.web.CustomUsernamePasswordAuthenticationFilter;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.util.matcher.RequestMatcher;

public final class CustomFormLoginConfig<H extends HttpSecurityBuilder<H>>
extends AbstractAuthenticationFilterConfigurer<H, CustomFormLoginConfig<H>, CustomUsernamePasswordAuthenticationFilter> {
    public CustomFormLoginConfig() {
        super((AbstractAuthenticationProcessingFilter)new CustomUsernamePasswordAuthenticationFilter(), null);
        ((CustomUsernamePasswordAuthenticationFilter)this.getAuthenticationFilter()).setPasswordParameter("username");
        ((CustomUsernamePasswordAuthenticationFilter)this.getAuthenticationFilter()).setPasswordParameter("password");
    }

    public CustomFormLoginConfig<H> usernameParameter(String usernameParameter) {
        ((CustomUsernamePasswordAuthenticationFilter)this.getAuthenticationFilter()).setUsernameParameter(usernameParameter);
        return this;
    }

    public CustomFormLoginConfig<H> passwordParameter(String passwordParameter) {
        ((CustomUsernamePasswordAuthenticationFilter)this.getAuthenticationFilter()).setPasswordParameter(passwordParameter);
        return this;
    }

    public void init(H http) throws Exception {
        super.init(http);
        this.initDefaultLoginFilter(http);
    }

    protected RequestMatcher createLoginProcessingUrlMatcher(String loginProcessingUrl) {
        return new CustomAntPathMatcher(loginProcessingUrl, "POST");
    }

    private void initDefaultLoginFilter(H http) {
        DefaultLoginPageGeneratingFilter loginPageGeneratingFilter = (DefaultLoginPageGeneratingFilter)http.getSharedObject(DefaultLoginPageGeneratingFilter.class);
        if (loginPageGeneratingFilter != null && !this.isCustomLoginPage()) {
            loginPageGeneratingFilter.setFormLoginEnabled(true);
            loginPageGeneratingFilter.setUsernameParameter(((CustomUsernamePasswordAuthenticationFilter)this.getAuthenticationFilter()).getUsernameParameter());
            loginPageGeneratingFilter.setPasswordParameter(((CustomUsernamePasswordAuthenticationFilter)this.getAuthenticationFilter()).getPasswordParameter());
            loginPageGeneratingFilter.setLoginPageUrl(this.getLoginPage());
            loginPageGeneratingFilter.setFailureUrl(this.getFailureUrl());
            loginPageGeneratingFilter.setAuthenticationUrl(this.getLoginProcessingUrl());
        }
    }
}

