/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.app.model.idm;

import org.activiti.app.model.common.AbstractRepresentation;
import org.activiti.engine.identity.Group;

/**
 * @author Joram Barrez
 */
public class GroupRepresentation extends AbstractRepresentation {
  
  protected String id;
  protected String name;
  protected String type;
  
  public GroupRepresentation() {
  }
  
  public GroupRepresentation(Group group) {
    setId(group.getId());
    setName(group.getName());
    setType(group.getType());
  }
  
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id = id;
  }
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }
  
}
