/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.model.runtime;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;

public class RestVariable {
    private String name;
    private String type;
    private RestVariableScope variableScope;
    private Object value;
    private String valueUrl;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    public RestVariableScope getVariableScope() {
        return this.variableScope;
    }

    public void setVariableScope(RestVariableScope variableScope) {
        this.variableScope = variableScope;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getScope() {
        String scope = null;
        if (this.variableScope != null) {
            scope = this.variableScope.name().toLowerCase();
        }
        return scope;
    }

    public void setScope(String scope) {
        this.setVariableScope(RestVariable.getScopeFromString(scope));
    }

    public void setValueUrl(String valueUrl) {
        this.valueUrl = valueUrl;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getValueUrl() {
        return this.valueUrl;
    }

    public static RestVariableScope getScopeFromString(String scope) {
        if (scope != null) {
            for (RestVariableScope s : RestVariableScope.values()) {
                if (!s.name().equalsIgnoreCase(scope)) continue;
                return s;
            }
            return null;
        }
        return null;
    }

    public static enum RestVariableScope {
        LOCAL,
        GLOBAL;

    }
}

