/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.security;

import org.activiti.app.security.ActivitiAppUser;
import org.activiti.engine.identity.User;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public final class SecurityUtils {
    private static User assumeUser;

    private SecurityUtils() {
    }

    public static String getCurrentUserId() {
        User user = SecurityUtils.getCurrentUserObject();
        if (user != null) {
            return user.getId();
        }
        return null;
    }

    public static User getCurrentUserObject() {
        if (assumeUser != null) {
            return assumeUser;
        }
        User user = null;
        ActivitiAppUser appUser = SecurityUtils.getCurrentActivitiAppUser();
        if (appUser != null) {
            user = appUser.getUserObject();
        }
        return user;
    }

    public static ActivitiAppUser getCurrentActivitiAppUser() {
        Object principal;
        SecurityContext securityContext = SecurityContextHolder.getContext();
        ActivitiAppUser user = null;
        if (securityContext != null && securityContext.getAuthentication() != null && (principal = securityContext.getAuthentication().getPrincipal()) != null && principal instanceof ActivitiAppUser) {
            user = (ActivitiAppUser)((Object)principal);
        }
        return user;
    }

    public static boolean currentUserHasCapability(String capability) {
        ActivitiAppUser user = SecurityUtils.getCurrentActivitiAppUser();
        for (GrantedAuthority grantedAuthority : user.getAuthorities()) {
            if (!capability.equals(grantedAuthority.getAuthority())) continue;
            return true;
        }
        return false;
    }

    public static void assumeUser(User user) {
        assumeUser = user;
    }

    public static void clearAssumeUser() {
        assumeUser = null;
    }
}

