/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.service.editor;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.activiti.app.model.idm.UserRepresentation;
import org.activiti.app.model.runtime.TaskRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.api.UserCache;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.exception.NotFoundException;
import org.activiti.app.service.exception.NotPermittedException;
import org.activiti.app.service.runtime.PermissionService;
import org.activiti.app.service.util.TaskUtil;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricIdentityLink;
import org.activiti.engine.identity.User;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivitiTaskActionService {
    private static final Logger logger = LoggerFactory.getLogger(ActivitiTaskActionService.class);
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected TaskService taskService;
    @Autowired
    protected PermissionService permissionService;
    @Autowired
    protected IdentityService identityService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected UserCache userCache;

    public void completeTask(String taskId) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task with id: " + taskId + " does not exist");
        }
        if (!this.permissionService.isTaskOwnerOrAssignee(currentUser, task) && !this.permissionService.validateIfUserIsInitiatorAndCanCompleteTask(currentUser, task)) {
            throw new NotPermittedException();
        }
        try {
            this.taskService.complete(task.getId());
        }
        catch (ActivitiException e) {
            logger.error("Error completing task " + taskId, (Throwable)e);
            throw new BadRequestException("Task " + taskId + " can't be completed", e);
        }
    }

    public TaskRepresentation assignTask(String taskId, ObjectNode requestNode) {
        String assigneeIdString;
        User currentUser = SecurityUtils.getCurrentUserObject();
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task with id: " + taskId + " does not exist");
        }
        this.checkTaskPermissions(taskId, currentUser, task);
        if (requestNode.get("assignee") != null) {
            assigneeIdString = requestNode.get("assignee").asText();
            UserCache.CachedUser cachedUser = this.userCache.getUser(assigneeIdString);
            if (cachedUser == null) {
                throw new BadRequestException("Invalid assignee id");
            }
        } else {
            throw new BadRequestException("Assignee is required");
        }
        this.assignTask(currentUser, task, assigneeIdString);
        task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        TaskRepresentation rep = new TaskRepresentation(task);
        TaskUtil.fillPermissionInformation(rep, (TaskInfo)task, currentUser, this.identityService, this.historyService, this.repositoryService);
        this.populateAssignee((TaskInfo)task, rep);
        rep.setInvolvedPeople(this.getInvolvedUsers(taskId));
        return rep;
    }

    public void involveUser(String taskId, ObjectNode requestNode) {
        String userId;
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task with id: " + taskId + " does not exist");
        }
        User currentUser = SecurityUtils.getCurrentUserObject();
        this.permissionService.validateReadPermissionOnTask(currentUser, task.getId());
        if (requestNode.get("userId") != null) {
            userId = requestNode.get("userId").asText();
            UserCache.CachedUser user = this.userCache.getUser(userId);
            if (user == null) {
                throw new BadRequestException("Invalid user id");
            }
        } else {
            throw new BadRequestException("User id is required");
        }
        this.taskService.addUserIdentityLink(taskId, userId.toString(), "participant");
    }

    public void removeInvolvedUser(String taskId, ObjectNode requestNode) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task with id: " + taskId + " does not exist");
        }
        this.permissionService.validateReadPermissionOnTask(SecurityUtils.getCurrentUserObject(), task.getId());
        String assigneeString = null;
        if (requestNode.get("userId") != null) {
            String userId = requestNode.get("userId").asText();
            if (this.userCache.getUser(userId) == null) {
                throw new BadRequestException("Invalid user id");
            }
            assigneeString = String.valueOf(userId);
        } else if (requestNode.get("email") != null) {
            String email;
            assigneeString = email = requestNode.get("email").asText();
        } else {
            throw new BadRequestException("User id or email is required");
        }
        this.taskService.deleteUserIdentityLink(taskId, assigneeString, "participant");
    }

    public void claimTask(String taskId) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task with id: " + taskId + " does not exist");
        }
        this.permissionService.validateReadPermissionOnTask(currentUser, task.getId());
        try {
            this.taskService.claim(task.getId(), String.valueOf(currentUser.getId()));
        }
        catch (ActivitiException e) {
            throw new BadRequestException("Task " + taskId + " can't be claimed", e);
        }
    }

    protected void checkTaskPermissions(String taskId, User currentUser, Task task) {
        this.permissionService.validateReadPermissionOnTask(currentUser, task.getId());
    }

    protected String validateEmail(ObjectNode requestNode) {
        String email;
        String string = email = requestNode.get("email") != null ? requestNode.get("email").asText() : null;
        if (email == null) {
            throw new BadRequestException("Email is mandatory");
        }
        return email;
    }

    protected void assignTask(User currentUser, Task task, String assigneeIdString) {
        try {
            String oldAssignee = task.getAssignee();
            this.taskService.setAssignee(task.getId(), assigneeIdString);
            this.addIdentiyLinkForUser(task, oldAssignee, "participant");
            String currentUserIdString = String.valueOf(currentUser.getId());
            this.addIdentiyLinkForUser(task, currentUserIdString, "participant");
        }
        catch (ActivitiException e) {
            throw new BadRequestException("Task " + task.getId() + " can't be assigned", e);
        }
    }

    protected void addIdentiyLinkForUser(Task task, String userId, String linkType) {
        List identityLinks = this.taskService.getIdentityLinksForTask(task.getId());
        boolean isOldUserInvolved = false;
        for (IdentityLink identityLink : identityLinks) {
            if (!userId.equals(identityLink.getUserId()) || !identityLink.getType().equals("participant") && !identityLink.getType().equals("candidate")) continue;
            isOldUserInvolved = true;
        }
        if (!isOldUserInvolved) {
            this.taskService.addUserIdentityLink(task.getId(), userId, linkType);
        }
    }

    protected void populateAssignee(TaskInfo task, TaskRepresentation rep) {
        UserCache.CachedUser cachedUser;
        if (task.getAssignee() != null && (cachedUser = this.userCache.getUser(task.getAssignee())) != null && cachedUser.getUser() != null) {
            rep.setAssignee(new UserRepresentation(cachedUser.getUser()));
        }
    }

    protected List<UserRepresentation> getInvolvedUsers(String taskId) {
        List idLinks = this.historyService.getHistoricIdentityLinksForTask(taskId);
        ArrayList<UserRepresentation> result = new ArrayList<UserRepresentation>(idLinks.size());
        for (HistoricIdentityLink link : idLinks) {
            UserCache.CachedUser cachedUser;
            if (link.getUserId() == null || "assignee".equals(link.getType()) || (cachedUser = this.userCache.getUser(link.getUserId())) == null || cachedUser.getUser() == null) continue;
            result.add(new UserRepresentation(cachedUser.getUser()));
        }
        return result;
    }
}

