/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.service.editor;

import com.activiti.image.ImageGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.activiti.app.domain.editor.Model;
import org.activiti.bpmn.model.Artifact;
import org.activiti.bpmn.model.Association;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.Lane;
import org.activiti.bpmn.model.Pool;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ModelImageService {
    private final Logger log = LoggerFactory.getLogger(ModelImageService.class);
    private static float THUMBNAIL_WIDTH = 300.0f;
    protected BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();

    public void generateThumbnailImage(Model model, ObjectNode editorJsonNode) {
        try {
            BufferedImage modelImage;
            BpmnModel bpmnModel = this.bpmnJsonConverter.convertToBpmnModel((JsonNode)editorJsonNode);
            double scaleFactor = 1.0;
            GraphicInfo diagramInfo = this.calculateDiagramSize(bpmnModel);
            if (diagramInfo.getWidth() > (double)THUMBNAIL_WIDTH) {
                scaleFactor = diagramInfo.getWidth() / (double)THUMBNAIL_WIDTH;
                this.scaleDiagram(bpmnModel, scaleFactor);
            }
            if ((modelImage = ImageGenerator.createImage((BpmnModel)bpmnModel, (double)scaleFactor)) != null) {
                byte[] thumbnailBytes = ImageGenerator.createByteArrayForImage((BufferedImage)modelImage, (String)"png");
                model.setThumbnail(thumbnailBytes);
            }
        }
        catch (Exception e) {
            this.log.error("Error creating thumbnail image " + model.getId(), (Throwable)e);
        }
    }

    protected GraphicInfo calculateDiagramSize(BpmnModel bpmnModel) {
        GraphicInfo diagramInfo = new GraphicInfo();
        for (Pool pool : bpmnModel.getPools()) {
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(pool.getId());
            double elementMaxX = graphicInfo.getX() + graphicInfo.getWidth();
            double elementMaxY = graphicInfo.getY() + graphicInfo.getHeight();
            if (elementMaxX > diagramInfo.getWidth()) {
                diagramInfo.setWidth(elementMaxX);
            }
            if (!(elementMaxY > diagramInfo.getHeight())) continue;
            diagramInfo.setHeight(elementMaxY);
        }
        for (Process process : bpmnModel.getProcesses()) {
            this.calculateWidthForFlowElements(process.getFlowElements(), bpmnModel, diagramInfo);
            this.calculateWidthForArtifacts(process.getArtifacts(), bpmnModel, diagramInfo);
        }
        return diagramInfo;
    }

    protected void scaleDiagram(BpmnModel bpmnModel, double scaleFactor) {
        for (Pool pool : bpmnModel.getPools()) {
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(pool.getId());
            this.scaleGraphicInfo(graphicInfo, scaleFactor);
        }
        for (Process process : bpmnModel.getProcesses()) {
            this.scaleFlowElements(process.getFlowElements(), bpmnModel, scaleFactor);
            this.scaleArtifacts(process.getArtifacts(), bpmnModel, scaleFactor);
            for (Lane lane : process.getLanes()) {
                this.scaleGraphicInfo(bpmnModel.getGraphicInfo(lane.getId()), scaleFactor);
            }
        }
    }

    protected void calculateWidthForFlowElements(Collection<FlowElement> elementList, BpmnModel bpmnModel, GraphicInfo diagramInfo) {
        for (FlowElement flowElement : elementList) {
            ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
            if (flowElement instanceof SequenceFlow) {
                List flowGraphics = bpmnModel.getFlowLocationGraphicInfo(flowElement.getId());
                if (flowGraphics != null && flowGraphics.size() > 0) {
                    graphicInfoList.addAll(flowGraphics);
                }
            } else {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowElement.getId());
                if (graphicInfo != null) {
                    graphicInfoList.add(graphicInfo);
                }
            }
            this.processGraphicInfoList(graphicInfoList, diagramInfo);
        }
    }

    protected void calculateWidthForArtifacts(Collection<Artifact> artifactList, BpmnModel bpmnModel, GraphicInfo diagramInfo) {
        for (Artifact artifact : artifactList) {
            ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
            if (artifact instanceof Association) {
                graphicInfoList.addAll(bpmnModel.getFlowLocationGraphicInfo(artifact.getId()));
            } else {
                graphicInfoList.add(bpmnModel.getGraphicInfo(artifact.getId()));
            }
            this.processGraphicInfoList(graphicInfoList, diagramInfo);
        }
    }

    protected void processGraphicInfoList(List<GraphicInfo> graphicInfoList, GraphicInfo diagramInfo) {
        for (GraphicInfo graphicInfo : graphicInfoList) {
            double elementMaxX = graphicInfo.getX() + graphicInfo.getWidth();
            double elementMaxY = graphicInfo.getY() + graphicInfo.getHeight();
            if (elementMaxX > diagramInfo.getWidth()) {
                diagramInfo.setWidth(elementMaxX);
            }
            if (!(elementMaxY > diagramInfo.getHeight())) continue;
            diagramInfo.setHeight(elementMaxY);
        }
    }

    protected void scaleFlowElements(Collection<FlowElement> elementList, BpmnModel bpmnModel, double scaleFactor) {
        for (FlowElement flowElement : elementList) {
            ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
            if (flowElement instanceof SequenceFlow) {
                List flowList = bpmnModel.getFlowLocationGraphicInfo(flowElement.getId());
                if (flowList != null) {
                    graphicInfoList.addAll(flowList);
                }
            } else {
                graphicInfoList.add(bpmnModel.getGraphicInfo(flowElement.getId()));
            }
            this.scaleGraphicInfoList(graphicInfoList, scaleFactor);
            if (!(flowElement instanceof SubProcess)) continue;
            SubProcess subProcess = (SubProcess)flowElement;
            this.scaleFlowElements(subProcess.getFlowElements(), bpmnModel, scaleFactor);
        }
    }

    protected void scaleArtifacts(Collection<Artifact> artifactList, BpmnModel bpmnModel, double scaleFactor) {
        for (Artifact artifact : artifactList) {
            ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
            if (artifact instanceof Association) {
                List flowList = bpmnModel.getFlowLocationGraphicInfo(artifact.getId());
                if (flowList != null) {
                    graphicInfoList.addAll(flowList);
                }
            } else {
                graphicInfoList.add(bpmnModel.getGraphicInfo(artifact.getId()));
            }
            this.scaleGraphicInfoList(graphicInfoList, scaleFactor);
        }
    }

    protected void scaleGraphicInfoList(List<GraphicInfo> graphicInfoList, double scaleFactor) {
        for (GraphicInfo graphicInfo : graphicInfoList) {
            this.scaleGraphicInfo(graphicInfo, scaleFactor);
        }
    }

    protected void scaleGraphicInfo(GraphicInfo graphicInfo, double scaleFactor) {
        graphicInfo.setX(graphicInfo.getX() / scaleFactor);
        graphicInfo.setY(graphicInfo.getY() / scaleFactor);
        graphicInfo.setWidth(graphicInfo.getWidth() / scaleFactor);
        graphicInfo.setHeight(graphicInfo.getHeight() / scaleFactor);
    }
}

