/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.history;

import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.CommentResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.Post;

public class HistoricProcessInstanceCommentCollectionResource
extends SecuredResource {
    @Get
    public List<CommentResponse> getComments() {
        if (!this.authenticate()) {
            return null;
        }
        ArrayList<CommentResponse> result = new ArrayList<CommentResponse>();
        RestResponseFactory responseFactory = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory();
        HistoricProcessInstance instance = this.getHistoricProcessInstanceFromRequest();
        for (Comment comment : ActivitiUtil.getTaskService().getProcessInstanceComments(instance.getId())) {
            result.add(responseFactory.createRestComment(this, comment));
        }
        return result;
    }

    @Post
    public CommentResponse createComment(CommentResponse comment) {
        if (!this.authenticate()) {
            return null;
        }
        HistoricProcessInstance instance = this.getHistoricProcessInstanceFromRequest();
        if (comment.getMessage() == null) {
            throw new ActivitiIllegalArgumentException("Comment text is required.");
        }
        Comment createdComment = ActivitiUtil.getTaskService().addComment(null, instance.getId(), comment.getMessage());
        this.setStatus(Status.SUCCESS_CREATED);
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createRestComment(this, createdComment);
    }

    protected HistoricProcessInstance getHistoricProcessInstanceFromRequest() {
        String processInstanceId = this.getAttribute("processInstanceId");
        if (processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("The processInstanceId cannot be null");
        }
        HistoricProcessInstance processInstance = (HistoricProcessInstance)ActivitiUtil.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new ActivitiObjectNotFoundException("Could not find a process instance with id '" + processInstanceId + "'.", HistoricProcessInstance.class);
        }
        return processInstance;
    }
}

