/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.history;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.MediaType;
import org.restlet.representation.InputRepresentation;
import org.restlet.resource.Get;

public class HistoricProcessInstanceVariableDataResource
extends SecuredResource {
    @Get
    public InputRepresentation getVariableData() {
        if (!this.authenticate()) {
            return null;
        }
        try {
            ByteArrayInputStream dataStream = null;
            MediaType mediaType = null;
            RestVariable variable = this.getVariableFromRequest(true);
            if ("binary".equals(variable.getType())) {
                dataStream = new ByteArrayInputStream((byte[])variable.getValue());
                mediaType = MediaType.APPLICATION_OCTET_STREAM;
            } else if ("serializable".equals(variable.getType())) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ObjectOutputStream outputStream = new ObjectOutputStream(buffer);
                outputStream.writeObject(variable.getValue());
                outputStream.close();
                dataStream = new ByteArrayInputStream(buffer.toByteArray());
                mediaType = MediaType.APPLICATION_JAVA_OBJECT;
            } else {
                throw new ActivitiObjectNotFoundException("The variable does not have a binary data stream.", null);
            }
            return new InputRepresentation((InputStream)dataStream, mediaType);
        }
        catch (IOException ioe) {
            throw new ActivitiException("Unexpected exception getting variable data", (Throwable)ioe);
        }
    }

    public RestVariable getVariableFromRequest(boolean includeBinary) {
        String processInstanceId = this.getAttribute("processInstanceId");
        if (processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("The processInstanceId cannot be null");
        }
        String variableName = this.getAttribute("variableName");
        if (variableName == null) {
            throw new ActivitiIllegalArgumentException("The variableName cannot be null");
        }
        HistoricProcessInstance processObject = (HistoricProcessInstance)ActivitiUtil.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).includeProcessVariables().singleResult();
        if (processObject == null) {
            throw new ActivitiObjectNotFoundException("Historic process instance '" + processInstanceId + "' couldn't be found.", HistoricProcessInstanceEntity.class);
        }
        Object value = processObject.getProcessVariables().get(variableName);
        if (value == null) {
            throw new ActivitiObjectNotFoundException("Historic process instance '" + processInstanceId + "' variable value for " + variableName + " couldn't be found.", VariableInstanceEntity.class);
        }
        RestResponseFactory responseFactory = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory();
        return responseFactory.createRestVariable(this, variableName, value, null, processInstanceId, 5, includeBinary);
    }
}

