/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.identity;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.identity.Group;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.identity.BaseGroupResource;
import org.restlet.data.Status;
import org.restlet.resource.Delete;

public class GroupMembershipResource
extends BaseGroupResource {
    @Delete
    public void deleteMembership() {
        if (!this.authenticate()) {
            return;
        }
        Group group = this.getGroupFromRequest();
        String userId = this.getAttribute("userId");
        if (userId == null) {
            throw new ActivitiIllegalArgumentException("UserId cannot be null.");
        }
        if (ActivitiUtil.getIdentityService().createUserQuery().memberOfGroup(group.getId()).userId(userId).count() != 1L) {
            throw new ActivitiObjectNotFoundException("User '" + userId + "' is not part of group '" + group.getId() + "'.", null);
        }
        ActivitiUtil.getIdentityService().deleteMembership(userId, group.getId());
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }
}

