/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.identity;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.identity.User;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.identity.BaseUserResource;
import org.activiti.rest.service.api.identity.UserInfoRequest;
import org.activiti.rest.service.api.identity.UserInfoResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Put;

public class UserInfoResource
extends BaseUserResource {
    @Get
    public UserInfoResponse getUserInfo() {
        if (!this.authenticate()) {
            return null;
        }
        User user = this.getUserFromRequest();
        String key = this.getAttribute("key");
        if (key == null) {
            throw new ActivitiIllegalArgumentException("Key cannot be null.");
        }
        String existingValue = ActivitiUtil.getIdentityService().getUserInfo(user.getId(), key);
        if (existingValue == null) {
            throw new ActivitiObjectNotFoundException("User info with key '" + key + "' does not exists for user '" + user.getId() + "'.", null);
        }
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createUserInfoResponse(this, key, existingValue, user.getId());
    }

    @Put
    public UserInfoResponse setUserInfo(UserInfoRequest request) {
        if (!this.authenticate()) {
            return null;
        }
        User user = this.getUserFromRequest();
        String key = this.getValidKeyFromRequest(user);
        if (request.getValue() == null) {
            throw new ActivitiIllegalArgumentException("The value cannot be null.");
        }
        if (request.getKey() != null && !key.equals(request.getKey())) {
            throw new ActivitiIllegalArgumentException("Key provided in request body doesn't match the key in the resource URL.");
        }
        ActivitiUtil.getIdentityService().setUserInfo(user.getId(), key, request.getValue());
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createUserInfoResponse(this, key, request.getValue(), user.getId());
    }

    @Delete
    public void deleteUserInfo() {
        if (!this.authenticate()) {
            return;
        }
        User user = this.getUserFromRequest();
        String key = this.getValidKeyFromRequest(user);
        ActivitiUtil.getIdentityService().setUserInfo(user.getId(), key, null);
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }

    protected String getValidKeyFromRequest(User user) {
        String key = this.getAttribute("key");
        if (key == null) {
            throw new ActivitiIllegalArgumentException("Key cannot be null.");
        }
        String existingValue = ActivitiUtil.getIdentityService().getUserInfo(user.getId(), key);
        if (existingValue == null) {
            throw new ActivitiObjectNotFoundException("User info with key '" + key + "' does not exists for user '" + user.getId() + "'.", null);
        }
        return key;
    }
}

