/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.identity;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.identity.Picture;
import org.activiti.engine.identity.User;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.identity.BaseUserResource;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.IOUtils;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Status;
import org.restlet.ext.fileupload.RestletFileUpload;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.restlet.resource.ResourceException;

public class UserPictureResource
extends BaseUserResource {
    @Get
    public InputRepresentation getUserPicture() {
        if (!this.authenticate()) {
            return null;
        }
        User user = this.getUserFromRequest();
        Picture userPicture = ActivitiUtil.getIdentityService().getUserPicture(user.getId());
        if (userPicture == null) {
            throw new ActivitiObjectNotFoundException("The user with id '" + user.getId() + "' does not have a picture.", Picture.class);
        }
        MediaType mediaType = MediaType.IMAGE_JPEG;
        if (userPicture.getMimeType() != null) {
            mediaType = MediaType.valueOf((String)userPicture.getMimeType());
        }
        return new InputRepresentation(userPicture.getInputStream(), mediaType);
    }

    @Put
    public void updateUserPicture(Representation representation) {
        if (!this.authenticate()) {
            return;
        }
        User user = this.getUserFromRequest();
        if (!MediaType.MULTIPART_FORM_DATA.isCompatible((Metadata)representation.getMediaType())) {
            throw new ResourceException(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE.getCode(), "The request should be of type 'multipart/form-data'.", null, null);
        }
        RestletFileUpload upload = new RestletFileUpload((FileItemFactory)new DiskFileItemFactory());
        try {
            FileItem uploadItem = null;
            List items = upload.parseRepresentation(representation);
            String mimeType = MediaType.IMAGE_JPEG.toString();
            for (FileItem fileItem : items) {
                if (fileItem.isFormField()) {
                    if (!"mimeType".equals(fileItem.getFieldName())) continue;
                    mimeType = fileItem.getString("UTF-8");
                    continue;
                }
                if (fileItem.getName() == null) continue;
                uploadItem = fileItem;
            }
            if (uploadItem == null) {
                throw new ActivitiIllegalArgumentException("No file content was found in request body.");
            }
            int size = Long.valueOf(uploadItem.getSize()).intValue();
            ByteArrayOutputStream bytesOutput = new ByteArrayOutputStream(size);
            IOUtils.copy((InputStream)uploadItem.getInputStream(), (OutputStream)bytesOutput);
            Picture newPicture = new Picture(bytesOutput.toByteArray(), mimeType);
            ActivitiUtil.getIdentityService().setUserPicture(user.getId(), newPicture);
        }
        catch (FileUploadException e) {
            throw new ActivitiException("Error with uploaded file: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ActivitiException("Error while reading uploaded file: " + e.getMessage(), (Throwable)e);
        }
    }
}

