/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.identity;

import org.activiti.engine.identity.User;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.identity.BaseUserResource;
import org.activiti.rest.service.api.identity.UserRequest;
import org.activiti.rest.service.api.identity.UserResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Put;

public class UserResource
extends BaseUserResource {
    @Get
    public UserResponse getUser() {
        if (!this.authenticate()) {
            return null;
        }
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createUserResponse(this, this.getUserFromRequest(), false);
    }

    @Put
    public UserResponse updateUser(UserRequest request) {
        if (!this.authenticate()) {
            return null;
        }
        User user = this.getUserFromRequest();
        if (request.isEmailChanged()) {
            user.setEmail(request.getEmail());
        }
        if (request.isFirstNameChanged()) {
            user.setFirstName(request.getFirstName());
        }
        if (request.isLastNameChanged()) {
            user.setLastName(request.getLastName());
        }
        if (request.isPasswordChanged()) {
            user.setPassword(request.getPassword());
        }
        ActivitiUtil.getIdentityService().saveUser(user);
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createUserResponse(this, user, false);
    }

    @Delete
    public void deleteUser() {
        if (!this.authenticate()) {
            return;
        }
        User user = this.getUserFromRequest();
        ActivitiUtil.getIdentityService().deleteUser(user.getId());
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }
}

