/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy;

import java.io.InputStream;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.task.Attachment;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.restlet.data.CacheDirective;
import org.restlet.data.MediaType;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;

public class LegacyTaskAttachmentResource
extends SecuredResource {
    @Get
    public InputRepresentation getAttachment() {
        if (!this.authenticate()) {
            return null;
        }
        String attachmentId = (String)this.getRequest().getAttributes().get("attachmentId");
        if (attachmentId == null) {
            throw new ActivitiIllegalArgumentException("No attachment id provided");
        }
        Attachment attachment = ActivitiUtil.getTaskService().getAttachment(attachmentId);
        if (attachment == null) {
            throw new ActivitiObjectNotFoundException("No attachment found for " + attachmentId, Attachment.class);
        }
        String contentType = attachment.getType();
        MediaType mediatType = MediaType.IMAGE_PNG;
        if (contentType != null) {
            if (contentType.contains(";")) {
                contentType = contentType.substring(0, contentType.indexOf(";"));
            }
            mediatType = MediaType.valueOf((String)contentType);
        }
        InputStream resource = ActivitiUtil.getTaskService().getAttachmentContent(attachmentId);
        InputRepresentation output = new InputRepresentation(resource, mediatType);
        this.getResponse().getCacheDirectives().add(CacheDirective.maxAge((int)28800));
        return output;
    }

    @Delete
    public void deleteAttachment(Representation entity) {
        if (!this.authenticate()) {
            return;
        }
        String attachmentId = (String)this.getRequest().getAttributes().get("attachmentId");
        if (attachmentId == null) {
            throw new ActivitiIllegalArgumentException("No attachment id provided");
        }
        ActivitiUtil.getTaskService().deleteAttachment(attachmentId);
    }
}

