/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.identity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.User;
import org.activiti.engine.impl.UserQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.legacy.identity.LegacyGroupUsersPaginateList;
import org.activiti.rest.service.api.legacy.identity.LegacyStateResponse;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.Post;

public class LegacyGroupUsersResource
extends SecuredResource {
    Map<String, QueryProperty> properties = new HashMap<String, QueryProperty>();

    public LegacyGroupUsersResource() {
        this.properties.put("id", (QueryProperty)UserQueryProperty.USER_ID);
        this.properties.put("firstName", (QueryProperty)UserQueryProperty.FIRST_NAME);
        this.properties.put("lastName", (QueryProperty)UserQueryProperty.LAST_NAME);
        this.properties.put("email", (QueryProperty)UserQueryProperty.EMAIL);
    }

    @Get
    public DataResponse getGroups() {
        if (!this.authenticate()) {
            return null;
        }
        String groupId = (String)this.getRequest().getAttributes().get("groupId");
        if (groupId == null) {
            throw new ActivitiIllegalArgumentException("No groupId provided");
        }
        DataResponse dataResponse = new LegacyGroupUsersPaginateList().paginateList(this.getQuery(), (Query)ActivitiUtil.getIdentityService().createUserQuery().memberOfGroup(groupId), "id", this.properties);
        return dataResponse;
    }

    @Post
    public LegacyStateResponse setUsers(ArrayList<String> userIds) {
        if (!this.authenticate()) {
            return null;
        }
        String groupId = (String)this.getRequest().getAttributes().get("groupId");
        if (groupId == null) {
            throw new ActivitiIllegalArgumentException("No groupId provided");
        }
        if (userIds == null) {
            throw new ActivitiIllegalArgumentException("No userIds provided");
        }
        IdentityService identityService = ActivitiUtil.getIdentityService();
        if (identityService.createGroupQuery().groupId(groupId).singleResult() == null) {
            throw new ActivitiObjectNotFoundException("The user '" + groupId + "' does not exist.", User.class);
        }
        for (String userId : userIds) {
            if (identityService.createUserQuery().userId(userId).singleResult() != null) continue;
            throw new ActivitiObjectNotFoundException("User '" + userId + " does not exist.", User.class);
        }
        for (String userId : userIds) {
            if (identityService.createUserQuery().userId(userId).memberOfGroup(groupId).singleResult() != null) continue;
            identityService.createMembership(userId, groupId);
        }
        return new LegacyStateResponse().setSuccess(true);
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }
}

