/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.identity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.identity.User;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.legacy.identity.LegacyUserInfo;
import org.restlet.data.Status;
import org.restlet.resource.Get;

public class LegacyUserSearchResource
extends SecuredResource {
    @Get
    public DataResponse searchUsers() {
        if (!this.authenticate()) {
            return null;
        }
        String searchText = this.getQuery().getValues("searchText");
        if (searchText == null) {
            throw new ActivitiIllegalArgumentException("No searchText provided");
        }
        searchText = "%" + searchText + "%";
        List firstNameMatchList = ActivitiUtil.getIdentityService().createUserQuery().userFirstNameLike(searchText).list();
        List lastNameMatchList = ActivitiUtil.getIdentityService().createUserQuery().userLastNameLike(searchText).list();
        HashMap<String, LegacyUserInfo> userMap = new HashMap<String, LegacyUserInfo>();
        if (firstNameMatchList != null) {
            for (User user : firstNameMatchList) {
                userMap.put(user.getId(), new LegacyUserInfo(user));
            }
        }
        if (lastNameMatchList != null) {
            for (User user : lastNameMatchList) {
                if (userMap.containsKey(user.getId())) continue;
                userMap.put(user.getId(), new LegacyUserInfo(user));
            }
        }
        ArrayList userList = new ArrayList();
        userList.addAll(userMap.values());
        Collections.sort(userList, new UserResponseComparable());
        DataResponse response = new DataResponse();
        response.setStart(0);
        response.setSize(userList.size());
        response.setSort("lastName");
        response.setOrder("asc");
        response.setTotal((long)userList.size());
        response.setData(userList);
        return response;
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }

    protected class UserResponseComparable
    implements Comparator<LegacyUserInfo> {
        protected UserResponseComparable() {
        }

        @Override
        public int compare(LegacyUserInfo user1, LegacyUserInfo user2) {
            return user1.getLastName().compareTo(user2.getLastName());
        }
    }
}

