/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.management;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.activiti.engine.management.TableMetaData;
import org.activiti.engine.management.TablePage;
import org.activiti.engine.management.TablePageQuery;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.RequestUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.resource.Get;

public class LegacyTableDataResource
extends SecuredResource {
    @Get
    public ObjectNode getTableData() {
        String sort;
        if (!this.authenticate("admin")) {
            return null;
        }
        String tableName = (String)this.getRequest().getAttributes().get("tableName");
        int start = RequestUtil.getInteger((Form)this.getQuery(), (String)"start", (int)0);
        int size = RequestUtil.getInteger((Form)this.getQuery(), (String)"size", (int)10);
        String order = this.getQuery().getValues("order");
        if (order == null) {
            order = "asc";
        }
        if ((sort = this.getQuery().getValues("sort")) == null) {
            TableMetaData tmd = ActivitiUtil.getManagementService().getTableMetaData(tableName);
            List columnNames = tmd.getColumnNames();
            sort = columnNames.size() > 0 ? (String)columnNames.get(0) : null;
        }
        TablePageQuery query = ActivitiUtil.getManagementService().createTablePageQuery().tableName(tableName);
        if (sort != null) {
            if (order.equals("asc")) {
                query.orderAsc(sort);
            } else {
                query.orderDesc(sort);
            }
        }
        TablePage tablePage = query.listPage(start, size);
        ObjectNode responseJSON = new ObjectMapper().createObjectNode();
        responseJSON.put("sort", sort);
        responseJSON.put("order", order);
        responseJSON.put("start", tablePage.getFirstResult());
        responseJSON.put("size", tablePage.getSize());
        responseJSON.put("total", tablePage.getTotal());
        ArrayNode tableArray = new ObjectMapper().createArrayNode();
        for (Map row : tablePage.getRows()) {
            ObjectNode columnJSON = new ObjectMapper().createObjectNode();
            for (String name : row.keySet()) {
                if (row.get(name) instanceof byte[]) {
                    columnJSON.put(name, ((byte[])row.get(name)).length);
                    continue;
                }
                if (row.get(name) instanceof Date) {
                    columnJSON.put(name, RequestUtil.dateToString((Date)((Date)row.get(name))));
                    continue;
                }
                columnJSON.put(name, row.get(name).toString());
            }
            tableArray.add((JsonNode)columnJSON);
        }
        responseJSON.put("data", (JsonNode)tableArray);
        return responseJSON;
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }
}

