/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.process;

import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.impl.HistoricProcessInstanceQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.legacy.process.LegacyProcessInstancesPaginateList;
import org.restlet.data.Status;
import org.restlet.resource.Get;

public class LegacyProcessInstancesResource
extends SecuredResource {
    Map<String, QueryProperty> properties = new HashMap<String, QueryProperty>();

    public LegacyProcessInstancesResource() {
        this.properties.put("id", (QueryProperty)HistoricProcessInstanceQueryProperty.PROCESS_INSTANCE_ID_);
        this.properties.put("processDefinitionId", (QueryProperty)HistoricProcessInstanceQueryProperty.PROCESS_DEFINITION_ID);
        this.properties.put("businessKey", (QueryProperty)HistoricProcessInstanceQueryProperty.BUSINESS_KEY);
        this.properties.put("startTime", (QueryProperty)HistoricProcessInstanceQueryProperty.START_TIME);
    }

    @Get
    public DataResponse getProcessInstances() {
        if (!this.authenticate()) {
            return null;
        }
        HistoricProcessInstanceQuery query = ActivitiUtil.getHistoryService().createHistoricProcessInstanceQuery();
        query = query.unfinished();
        String processDefinitionId = this.getQuery().getValues("processDefinitionId");
        String processInstanceKey = this.getQuery().getValues("businessKey");
        query = processDefinitionId == null ? query : query.processDefinitionId(processDefinitionId);
        query = processInstanceKey == null ? query : query.processInstanceBusinessKey(processInstanceKey);
        DataResponse response = new LegacyProcessInstancesPaginateList().paginateList(this.getQuery(), (Query)query, "id", this.properties);
        return response;
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }
}

