/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.process;

import java.io.InputStream;
import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.diagram.ProcessDiagramGenerator;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.InputRepresentation;
import org.restlet.resource.Get;

public class ProcessInstanceDiagramResource
extends SecuredResource {
    @Get
    public InputRepresentation getInstanceDiagram() {
        String processInstanceId = (String)this.getRequest().getAttributes().get("processInstanceId");
        if (processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("No process instance id provided");
        }
        ExecutionEntity pi = (ExecutionEntity)ActivitiUtil.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (pi == null) {
            throw new ActivitiObjectNotFoundException("Process instance with id" + processInstanceId + " could not be found", ProcessInstance.class);
        }
        ProcessDefinitionEntity pde = (ProcessDefinitionEntity)((RepositoryServiceImpl)ActivitiUtil.getRepositoryService()).getDeployedProcessDefinition(pi.getProcessDefinitionId());
        if (pde != null && pde.isGraphicalNotationDefined()) {
            BpmnModel bpmnModel = ActivitiUtil.getRepositoryService().getBpmnModel(pde.getId());
            InputStream resource = ProcessDiagramGenerator.generateDiagram((BpmnModel)bpmnModel, (String)"png", (List)ActivitiUtil.getRuntimeService().getActiveActivityIds(processInstanceId));
            InputRepresentation output = new InputRepresentation(resource, MediaType.IMAGE_PNG);
            return output;
        }
        throw new ActivitiException("Process instance with id " + processInstanceId + " has no graphic description");
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }
}

