/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.process;

import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.legacy.process.StartProcessInstanceResponse;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;

public class StartProcessInstanceResource
extends SecuredResource {
    @Post
    public StartProcessInstanceResponse startProcessInstance(Representation entity) {
        try {
            if (!this.authenticate()) {
                return null;
            }
            String startParams = entity.getText();
            JsonNode startJSON = new ObjectMapper().readTree(startParams);
            String processDefinitionKey = startJSON.path("processDefinitionKey").getTextValue();
            String processDefinitionId = null;
            if (processDefinitionKey == null) {
                processDefinitionId = startJSON.path("processDefinitionId").getTextValue();
            }
            JsonNode businessKeyJson = startJSON.path("businessKey");
            String businessKey = null;
            if (businessKeyJson != null) {
                businessKey = businessKeyJson.getTextValue();
            }
            Map variables = this.retrieveVariables(startJSON);
            variables.remove("processDefinitionId");
            variables.remove("processDefinitionKey");
            variables.remove("businessKey");
            ProcessInstance processInstance = null;
            processInstance = processDefinitionKey != null ? ActivitiUtil.getRuntimeService().startProcessInstanceByKey(processDefinitionKey, businessKey, variables) : ActivitiUtil.getRuntimeService().startProcessInstanceById(processDefinitionId, businessKey, variables);
            StartProcessInstanceResponse response = new StartProcessInstanceResponse(processInstance);
            return response;
        }
        catch (Exception e) {
            if (e instanceof ActivitiException) {
                throw (ActivitiException)e;
            }
            throw new ActivitiException("Failed to retrieve the process definition parameters", (Throwable)e);
        }
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }
}

