/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.repository.BaseDeploymentResourceDataResource;
import org.restlet.representation.InputRepresentation;
import org.restlet.resource.Get;

public class ProcessDefinitionResourceDataResource
extends BaseDeploymentResourceDataResource {
    @Get
    public InputRepresentation getProcessDefinitionResource() {
        if (!this.authenticate()) {
            return null;
        }
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest();
        return this.getDeploymentResource(processDefinition.getDeploymentId(), processDefinition.getResourceName());
    }

    protected ProcessDefinition getProcessDefinitionFromRequest() {
        String processDefinitionId = this.getAttribute("processDefinitionId");
        if (processDefinitionId == null) {
            throw new ActivitiIllegalArgumentException("The processDefinitionId cannot be null");
        }
        ProcessDefinition processDefinition = (ProcessDefinition)ActivitiUtil.getRepositoryService().createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("Could not find a process definition with id '" + processDefinitionId + "'.", ProcessDefinition.class);
        }
        return processDefinition;
    }
}

