/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime;

import java.util.HashMap;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.process.SignalEventReceivedRequest;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Post;

public class SignalResource
extends SecuredResource {
    @Post
    public void signalEventReceived(SignalEventReceivedRequest signalRequest) {
        if (!this.authenticate()) {
            return;
        }
        if (signalRequest.getSignalName() == null) {
            throw new ActivitiIllegalArgumentException("signalName is required");
        }
        HashMap<String, Object> signalVariables = null;
        if (signalRequest.getVariables() != null) {
            RestResponseFactory factory = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory();
            signalVariables = new HashMap<String, Object>();
            for (RestVariable variable : signalRequest.getVariables()) {
                if (variable.getName() == null) {
                    throw new ActivitiIllegalArgumentException("Variable name is required.");
                }
                signalVariables.put(variable.getName(), factory.getVariableValue(variable));
            }
        }
        if (signalRequest.isAsync()) {
            if (signalVariables != null) {
                throw new ActivitiIllegalArgumentException("Async signals cannot take variables as payload");
            }
            if (signalRequest.isCustomTenantSet()) {
                ActivitiUtil.getRuntimeService().signalEventReceivedAsyncWithTenantId(signalRequest.getSignalName(), signalRequest.getTenantId());
            } else {
                ActivitiUtil.getRuntimeService().signalEventReceivedAsync(signalRequest.getSignalName());
            }
            this.setStatus(Status.SUCCESS_ACCEPTED);
        } else {
            if (signalRequest.isCustomTenantSet()) {
                ActivitiUtil.getRuntimeService().signalEventReceivedWithTenantId(signalRequest.getSignalName(), signalVariables, signalRequest.getTenantId());
            } else {
                ActivitiUtil.getRuntimeService().signalEventReceived(signalRequest.getSignalName(), signalVariables);
            }
            this.setStatus(Status.SUCCESS_OK);
        }
    }
}

