/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.IOUtils;
import org.restlet.data.Status;
import org.restlet.ext.fileupload.RestletFileUpload;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;

public class BaseExecutionVariableResource
extends SecuredResource {
    protected RestVariable setBinaryVariable(Representation representation, Execution execution, boolean isNew) {
        try {
            RestletFileUpload upload = new RestletFileUpload((FileItemFactory)new DiskFileItemFactory());
            List items = upload.parseRepresentation(representation);
            String variableScope = null;
            String variableName = null;
            String variableType = null;
            FileItem uploadItem = null;
            for (FileItem fileItem : items) {
                if (fileItem.isFormField()) {
                    if ("scope".equals(fileItem.getFieldName())) {
                        variableScope = fileItem.getString("UTF-8");
                        continue;
                    }
                    if ("name".equals(fileItem.getFieldName())) {
                        variableName = fileItem.getString("UTF-8");
                        continue;
                    }
                    if (!"type".equals(fileItem.getFieldName())) continue;
                    variableType = fileItem.getString("UTF-8");
                    continue;
                }
                if (fileItem.getName() == null) continue;
                uploadItem = fileItem;
            }
            if (uploadItem == null) {
                throw new ActivitiIllegalArgumentException("No file content was found in request body.");
            }
            if (variableName == null) {
                throw new ActivitiIllegalArgumentException("No variable name was found in request body.");
            }
            if (variableType != null) {
                if (!"binary".equals(variableType) && !"serializable".equals(variableType)) {
                    throw new ActivitiIllegalArgumentException("Only 'binary' and 'serializable' are supported as variable type.");
                }
            } else {
                variableType = "binary";
            }
            RestVariable.RestVariableScope scope = RestVariable.RestVariableScope.LOCAL;
            if (variableScope != null) {
                scope = RestVariable.getScopeFromString(variableScope);
            }
            if (variableType.equals("binary")) {
                ByteArrayOutputStream variableOutput = new ByteArrayOutputStream(Long.valueOf(uploadItem.getSize()).intValue());
                IOUtils.copy((InputStream)uploadItem.getInputStream(), (OutputStream)variableOutput);
                this.setVariable(execution, variableName, variableOutput.toByteArray(), scope, isNew);
            } else {
                ObjectInputStream stream = new ObjectInputStream(uploadItem.getInputStream());
                Object value = stream.readObject();
                this.setVariable(execution, variableName, value, scope, isNew);
                stream.close();
            }
            if (execution instanceof ProcessInstance && this.allowProcessInstanceUrl()) {
                return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createBinaryRestVariable(this, variableName, scope, variableType, null, null, execution.getId());
            }
            return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createBinaryRestVariable(this, variableName, scope, variableType, null, execution.getId(), null);
        }
        catch (FileUploadException fue) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, (Throwable)fue);
        }
        catch (IOException ioe) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, (Throwable)ioe);
        }
        catch (ClassNotFoundException ioe) {
            throw new ResourceException(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE.getCode(), "The provided body contains a serialized object for which the class is nog found: " + ioe.getMessage(), null, null);
        }
    }

    protected RestVariable setSimpleVariable(RestVariable restVariable, Execution execution, boolean isNew) {
        if (restVariable.getName() == null) {
            throw new ActivitiIllegalArgumentException("Variable name is required");
        }
        RestVariable.RestVariableScope scope = restVariable.getVariableScope();
        if (scope == null) {
            scope = RestVariable.RestVariableScope.LOCAL;
        }
        Object actualVariableValue = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().getVariableValue(restVariable);
        this.setVariable(execution, restVariable.getName(), actualVariableValue, scope, isNew);
        return this.constructRestVariable(this, restVariable.getName(), actualVariableValue, scope, execution.getId(), false);
    }

    protected void setVariable(Execution execution, String name, Object value, RestVariable.RestVariableScope scope, boolean isNew) {
        boolean hasVariable = this.hasVariableOnScope(execution, name, scope);
        if (isNew && hasVariable) {
            throw new ResourceException(new Status(Status.CLIENT_ERROR_CONFLICT.getCode(), "Variable '" + name + "' is already present on execution '" + execution.getId() + "'.", null, null));
        }
        if (!isNew && !hasVariable) {
            throw new ActivitiObjectNotFoundException("Execution '" + execution.getId() + "' doesn't have a variable with name: '" + name + "'.", null);
        }
        if (scope == RestVariable.RestVariableScope.LOCAL) {
            ActivitiUtil.getRuntimeService().setVariableLocal(execution.getId(), name, value);
        } else if (execution.getParentId() != null) {
            ActivitiUtil.getRuntimeService().setVariable(execution.getParentId(), name, value);
        } else {
            ActivitiUtil.getRuntimeService().setVariable(execution.getId(), name, value);
        }
    }

    protected boolean hasVariableOnScope(Execution execution, String variableName, RestVariable.RestVariableScope scope) {
        boolean variableFound = false;
        if (scope == RestVariable.RestVariableScope.GLOBAL) {
            if (execution.getParentId() != null && ActivitiUtil.getRuntimeService().hasVariable(execution.getParentId(), variableName)) {
                variableFound = true;
            }
        } else if (scope == RestVariable.RestVariableScope.LOCAL && ActivitiUtil.getRuntimeService().hasVariableLocal(execution.getId(), variableName)) {
            variableFound = true;
        }
        return variableFound;
    }

    public RestVariable getVariableFromRequest(boolean includeBinary) {
        String executionId = this.getAttribute(this.getExecutionIdParameter());
        if (executionId == null) {
            throw new ActivitiIllegalArgumentException("The " + this.getExecutionIdParameter() + " cannot be null");
        }
        String variableName = this.getAttribute("variableName");
        if (variableName == null) {
            throw new ActivitiIllegalArgumentException("The variableName cannot be null");
        }
        boolean variableFound = false;
        Object value = null;
        RestVariable.RestVariableScope variableScope = RestVariable.getScopeFromString(this.getQueryParameter("scope", this.getQuery()));
        if (variableScope == null) {
            if (ActivitiUtil.getRuntimeService().hasVariableLocal(executionId, variableName)) {
                value = ActivitiUtil.getRuntimeService().getVariableLocal(executionId, variableName);
                variableScope = RestVariable.RestVariableScope.LOCAL;
                variableFound = true;
            } else {
                Execution execution = (Execution)ActivitiUtil.getRuntimeService().createExecutionQuery().executionId(executionId).singleResult();
                if (execution == null) {
                    throw new ActivitiObjectNotFoundException("Could not find an execution with id '" + executionId + "'.", ProcessInstance.class);
                }
                if (execution.getParentId() != null) {
                    value = ActivitiUtil.getRuntimeService().getVariable(executionId, execution.getParentId());
                    variableScope = RestVariable.RestVariableScope.GLOBAL;
                    variableFound = true;
                }
            }
        } else if (variableScope == RestVariable.RestVariableScope.GLOBAL) {
            Execution execution = (Execution)ActivitiUtil.getRuntimeService().createExecutionQuery().executionId(executionId).singleResult();
            if (execution == null) {
                throw new ActivitiObjectNotFoundException("Could not find an execution with id '" + executionId + "'.", ProcessInstance.class);
            }
            if (execution.getParentId() != null) {
                value = ActivitiUtil.getRuntimeService().getVariable(execution.getParentId(), variableName);
                variableScope = RestVariable.RestVariableScope.GLOBAL;
                variableFound = true;
            }
        } else if (variableScope == RestVariable.RestVariableScope.LOCAL) {
            value = ActivitiUtil.getRuntimeService().getVariableLocal(executionId, variableName);
            variableScope = RestVariable.RestVariableScope.LOCAL;
            variableFound = true;
        }
        if (!variableFound) {
            throw new ActivitiObjectNotFoundException("Execution '" + executionId + "' doesn't have a variable with name: '" + variableName + "'.", VariableInstanceEntity.class);
        }
        return this.constructRestVariable(this, variableName, value, variableScope, executionId, includeBinary);
    }

    protected RestVariable constructRestVariable(SecuredResource securedResource, String variableName, Object value, RestVariable.RestVariableScope variableScope, String executionId, boolean includeBinary) {
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createRestVariable(this, variableName, value, variableScope, executionId, 2, includeBinary);
    }

    protected Execution getExecutionFromRequest() {
        String executionId = this.getAttribute(this.getExecutionIdParameter());
        if (executionId == null) {
            throw new ActivitiIllegalArgumentException("The " + this.getExecutionIdParameter() + " cannot be null");
        }
        Execution execution = (Execution)ActivitiUtil.getRuntimeService().createExecutionQuery().executionId(executionId).singleResult();
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("Could not find an execution with id '" + executionId + "'.", Execution.class);
        }
        return execution;
    }

    protected String getExecutionIdParameter() {
        return "executionId";
    }

    protected boolean allowProcessInstanceUrl() {
        return false;
    }
}

