/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.runtime.Execution;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.process.BaseExecutionVariableResource;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.Put;
import org.restlet.resource.Resource;
import org.restlet.resource.ResourceException;

public class ExecutionVariableCollectionResource
extends BaseExecutionVariableResource {
    @Get
    public List<RestVariable> getVariables() {
        if (!this.authenticate()) {
            return null;
        }
        Execution execution = this.getExecutionFromRequest();
        ArrayList<RestVariable> result = new ArrayList<RestVariable>();
        HashMap<String, RestVariable> variableMap = new HashMap<String, RestVariable>();
        RestVariable.RestVariableScope variableScope = RestVariable.getScopeFromString(this.getQueryParameter("scope", this.getQuery()));
        if (variableScope == null) {
            this.addLocalVariables(execution, variableMap);
            this.addGlobalVariables(execution, variableMap);
        } else if (variableScope == RestVariable.RestVariableScope.GLOBAL) {
            this.addGlobalVariables(execution, variableMap);
        } else if (variableScope == RestVariable.RestVariableScope.LOCAL) {
            this.addLocalVariables(execution, variableMap);
        }
        result.addAll(variableMap.values());
        return result;
    }

    @Put
    public Object createOrUpdateExecutionVariable(Representation representation) {
        if (!this.authenticate()) {
            return null;
        }
        return this.createExecutionVariable(representation, true);
    }

    @Post
    public Object createExecutionVariable(Representation representation) {
        if (!this.authenticate()) {
            return null;
        }
        return this.createExecutionVariable(representation, false);
    }

    @Delete
    public void deleteAllLocalVariables() {
        if (!this.authenticate()) {
            return;
        }
        Execution execution = this.getExecutionFromRequest();
        Set currentVariables = ActivitiUtil.getRuntimeService().getVariablesLocal(execution.getId()).keySet();
        ActivitiUtil.getRuntimeService().removeVariablesLocal(execution.getId(), currentVariables);
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }

    protected Object createExecutionVariable(Representation representation, boolean override) {
        Object result;
        block14: {
            if (!this.authenticate()) {
                return null;
            }
            Execution execution = this.getExecutionFromRequest();
            result = null;
            if (MediaType.MULTIPART_FORM_DATA.isCompatible((Metadata)representation.getMediaType())) {
                result = this.setBinaryVariable(representation, execution, true);
            } else {
                try {
                    ArrayList<RestVariable> variables = new ArrayList<RestVariable>();
                    result = variables;
                    RestVariable[] restVariables = (RestVariable[])this.getConverterService().toObject(representation, RestVariable[].class, (Resource)this);
                    if (restVariables == null || restVariables.length == 0) {
                        throw new ActivitiIllegalArgumentException("Request didn't contain a list of variables to create.");
                    }
                    RestVariable.RestVariableScope sharedScope = null;
                    RestVariable.RestVariableScope varScope = null;
                    HashMap<String, Object> variablesToSet = new HashMap<String, Object>();
                    RestResponseFactory factory = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory();
                    for (RestVariable var : restVariables) {
                        varScope = var.getVariableScope();
                        if (var.getName() == null) {
                            throw new ActivitiIllegalArgumentException("Variable name is required");
                        }
                        if (varScope == null) {
                            varScope = RestVariable.RestVariableScope.LOCAL;
                        }
                        if (sharedScope == null) {
                            sharedScope = varScope;
                        }
                        if (varScope != sharedScope) {
                            throw new ActivitiIllegalArgumentException("Only allowed to update multiple variables in the same scope.");
                        }
                        if (!override && this.hasVariableOnScope(execution, var.getName(), varScope)) {
                            throw new ResourceException(new Status(Status.CLIENT_ERROR_CONFLICT.getCode(), "Variable '" + var.getName() + "' is already present on execution '" + execution.getId() + "'.", null, null));
                        }
                        Object actualVariableValue = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().getVariableValue(var);
                        variablesToSet.put(var.getName(), actualVariableValue);
                        variables.add(factory.createRestVariable(this, var.getName(), actualVariableValue, varScope, execution.getId(), 2, false));
                    }
                    if (variablesToSet.size() <= 0) break block14;
                    if (sharedScope == RestVariable.RestVariableScope.LOCAL) {
                        ActivitiUtil.getRuntimeService().setVariablesLocal(execution.getId(), variablesToSet);
                        break block14;
                    }
                    if (execution.getParentId() != null) {
                        ActivitiUtil.getRuntimeService().setVariables(execution.getParentId(), variablesToSet);
                        break block14;
                    }
                    throw new ActivitiIllegalArgumentException("Cannot set global variables on execution '" + execution.getId() + "', task is not part of process.");
                }
                catch (IOException ioe) {
                    throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, (Throwable)ioe);
                }
            }
        }
        this.setStatus(Status.SUCCESS_CREATED);
        return result;
    }

    protected void addGlobalVariables(Execution execution, Map<String, RestVariable> variableMap) {
        Map rawVariables = ActivitiUtil.getRuntimeService().getVariables(execution.getId());
        List<RestVariable> globalVariables = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createRestVariables(this, rawVariables, execution.getId(), 2, RestVariable.RestVariableScope.GLOBAL);
        for (RestVariable var : globalVariables) {
            if (variableMap.containsKey(var.getName())) continue;
            variableMap.put(var.getName(), var);
        }
    }

    protected void addLocalVariables(Execution execution, Map<String, RestVariable> variableMap) {
        Map rawLocalvariables = ActivitiUtil.getRuntimeService().getVariablesLocal(execution.getId());
        List<RestVariable> localVariables = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createRestVariables(this, rawLocalvariables, execution.getId(), 2, RestVariable.RestVariableScope.LOCAL);
        for (RestVariable var : localVariables) {
            variableMap.put(var.getName(), var);
        }
    }
}

