/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import java.io.IOException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.runtime.Execution;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.process.BaseExecutionVariableResource;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.restlet.resource.Resource;
import org.restlet.resource.ResourceException;

public class ExecutionVariableResource
extends BaseExecutionVariableResource {
    @Get
    public RestVariable getVariable() {
        if (!this.authenticate()) {
            return null;
        }
        return this.getVariableFromRequest(false);
    }

    @Put
    public RestVariable updateVariable(Representation representation) {
        if (!this.authenticate()) {
            return null;
        }
        String variableName = this.getAttribute("variableName");
        if (variableName == null) {
            throw new ActivitiIllegalArgumentException("The variableName cannot be null");
        }
        Execution execution = this.getExecutionFromRequest();
        RestVariable result = null;
        if (representation.getMediaType() != null && MediaType.MULTIPART_FORM_DATA.isCompatible((Metadata)representation.getMediaType())) {
            result = this.setBinaryVariable(representation, execution, false);
            if (!result.getName().equals(variableName)) {
                throw new ActivitiIllegalArgumentException("Variable name in the body should be equal to the name used in the requested URL.");
            }
        } else {
            try {
                RestVariable restVariable = (RestVariable)this.getConverterService().toObject(representation, RestVariable.class, (Resource)this);
                if (restVariable == null) {
                    throw new ResourceException(new Status(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE.getCode(), "Invalid body was supplied", null, null));
                }
                if (!restVariable.getName().equals(variableName)) {
                    throw new ActivitiIllegalArgumentException("Variable name in the body should be equal to the name used in the requested URL.");
                }
                result = this.setSimpleVariable(restVariable, execution, false);
            }
            catch (IOException ioe) {
                throw new ResourceException(Status.SERVER_ERROR_INTERNAL, (Throwable)ioe);
            }
        }
        return result;
    }

    @Delete
    public void deleteVariable() {
        if (!this.authenticate()) {
            return;
        }
        Execution execution = this.getExecutionFromRequest();
        String variableName = this.getAttribute("variableName");
        if (variableName == null) {
            throw new ActivitiIllegalArgumentException("The variableName cannot be null");
        }
        String scopeString = this.getQueryParameter("scope", this.getQuery());
        RestVariable.RestVariableScope scope = RestVariable.RestVariableScope.LOCAL;
        if (scopeString != null) {
            scope = RestVariable.getScopeFromString(scopeString);
        }
        if (!this.hasVariableOnScope(execution, variableName, scope)) {
            throw new ActivitiObjectNotFoundException("Execution '" + execution.getId() + "' doesn't have a variable '" + variableName + "' in scope " + scope.name().toLowerCase(), VariableInstanceEntity.class);
        }
        if (scope == RestVariable.RestVariableScope.LOCAL) {
            ActivitiUtil.getRuntimeService().removeVariableLocal(execution.getId(), variableName);
        } else {
            ActivitiUtil.getRuntimeService().removeVariable(execution.getParentId(), variableName);
        }
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }
}

